<?php //00abd709837b4041db492fa8853c2a7e
/** @noinspection all */

namespace Modules\Chat\Entities {

    use App\Models\LmsInstitute;
    use App\Models\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_C;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_BlockUser_C;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_BlockUser_QB;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_Conversation_C;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_Conversation_QB;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_GroupMessageRecipient_C;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_GroupMessageRecipient_QB;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_GroupMessageRemove_C;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_GroupMessageRemove_QB;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_GroupUser_C;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_GroupUser_QB;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_Group_C;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_Group_QB;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_Invitation_C;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_Invitation_QB;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_Notification_C;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_Notification_QB;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_Status_C;
    use LaravelIdea\Helper\Modules\Chat\Entities\_IH_Status_QB;
    
    /**
     * @property int $id
     * @property int $block_by
     * @property int $block_to
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $lms_id
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_BlockUser_QB onWriteConnection()
     * @method _IH_BlockUser_QB newQuery()
     * @method static _IH_BlockUser_QB on(null|string $connection = null)
     * @method static _IH_BlockUser_QB query()
     * @method static _IH_BlockUser_QB with(array|string $relations)
     * @method _IH_BlockUser_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_BlockUser_C|BlockUser[] all()
     * @mixin _IH_BlockUser_QB
     */
    class BlockUser extends Model {}
    
    /**
     * @property int $id
     * @property int|null $from_id
     * @property int|null $to_id
     * @property string|null $message
     * @property int $status
     * @property int $message_type
     * @property string|null $file_name
     * @property string|null $original_file_name
     * @property bool $initial
     * @property int|null $reply
     * @property int|null $forward
     * @property bool $deleted_by_to
     * @property Carbon|null $deleted_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $lms_id
     * @property-read $created_at_diff_human attribute
     * @property Conversation|null $forwardFrom
     * @method BelongsTo|_IH_Conversation_QB forwardFrom()
     * @property User|null $fromUser
     * @method BelongsTo|_IH_User_QB fromUser()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method BelongsTo|_IH_Conversation_QB reply()
     * @property User|null $toUser
     * @method BelongsTo|_IH_User_QB toUser()
     * @method static _IH_Conversation_QB onWriteConnection()
     * @method _IH_Conversation_QB newQuery()
     * @method static _IH_Conversation_QB on(null|string $connection = null)
     * @method static _IH_Conversation_QB query()
     * @method static _IH_Conversation_QB with(array|string $relations)
     * @method _IH_Conversation_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Conversation_C|Conversation[] all()
     * @mixin _IH_Conversation_QB
     */
    class Conversation extends Model {}
    
    /**
     * @property string $id
     * @property string $name
     * @property string|null $description
     * @property string|null $photo_url
     * @property int|null $privacy
     * @property bool $read_only
     * @property int $group_type
     * @property int $created_by
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $lms_id
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property _IH_GroupMessageRecipient_C|GroupMessageRecipient[] $threads
     * @property-read int $threads_count
     * @method HasMany|_IH_GroupMessageRecipient_QB threads()
     * @property _IH_User_C|User[] $users
     * @property-read int $users_count
     * @method BelongsToMany|_IH_User_QB users()
     * @method static _IH_Group_QB onWriteConnection()
     * @method _IH_Group_QB newQuery()
     * @method static _IH_Group_QB on(null|string $connection = null)
     * @method static _IH_Group_QB query()
     * @method static _IH_Group_QB with(array|string $relations)
     * @method _IH_Group_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Group_C|Group[] all()
     * @mixin _IH_Group_QB
     */
    class Group extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $conversation_id
     * @property string $group_id
     * @property Carbon|null $read_at
     * @property Carbon|null $deleted_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $lms_id
     * @property Conversation $conversation
     * @method BelongsTo|_IH_Conversation_QB conversation()
     * @property Group $group
     * @method BelongsTo|_IH_Group_QB group()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property _IH_GroupMessageRemove_C|GroupMessageRemove[] $removeMessages
     * @property-read int $remove_messages_count
     * @method HasMany|_IH_GroupMessageRemove_QB removeMessages()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_GroupMessageRecipient_QB onWriteConnection()
     * @method _IH_GroupMessageRecipient_QB newQuery()
     * @method static _IH_GroupMessageRecipient_QB on(null|string $connection = null)
     * @method static _IH_GroupMessageRecipient_QB query()
     * @method static _IH_GroupMessageRecipient_QB with(array|string $relations)
     * @method _IH_GroupMessageRecipient_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_GroupMessageRecipient_C|GroupMessageRecipient[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|group_id,\Modules\Group\Entities\Group,id
     * @mixin _IH_GroupMessageRecipient_QB
     */
    class GroupMessageRecipient extends Model {}
    
    /**
     * @property int $id
     * @property int $group_message_recipient_id
     * @property int $user_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $lms_id
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_GroupMessageRemove_QB onWriteConnection()
     * @method _IH_GroupMessageRemove_QB newQuery()
     * @method static _IH_GroupMessageRemove_QB on(null|string $connection = null)
     * @method static _IH_GroupMessageRemove_QB query()
     * @method static _IH_GroupMessageRemove_QB with(array|string $relations)
     * @method _IH_GroupMessageRemove_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_GroupMessageRemove_C|GroupMessageRemove[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_GroupMessageRemove_QB
     */
    class GroupMessageRemove extends Model {}
    
    /**
     * @property int $id
     * @property string $group_id
     * @property int $user_id
     * @property int $role
     * @property int $added_by
     * @property int|null $removed_by
     * @property Carbon|null $deleted_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $lms_id
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property User $user
     * @method HasOne|_IH_User_QB user()
     * @method static _IH_GroupUser_QB onWriteConnection()
     * @method _IH_GroupUser_QB newQuery()
     * @method static _IH_GroupUser_QB on(null|string $connection = null)
     * @method static _IH_GroupUser_QB query()
     * @method static _IH_GroupUser_QB with(array|string $relations)
     * @method _IH_GroupUser_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_GroupUser_C|GroupUser[] all()
     * @ownLinks group_id,\Modules\Group\Entities\Group,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_GroupUser_QB
     */
    class GroupUser extends Model {}
    
    /**
     * @property int $id
     * @property int $from
     * @property int $to
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $lms_id
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property User $requestFrom
     * @method BelongsTo|_IH_User_QB requestFrom()
     * @property User $requestTo
     * @method BelongsTo|_IH_User_QB requestTo()
     * @method static _IH_Invitation_QB onWriteConnection()
     * @method _IH_Invitation_QB newQuery()
     * @method static _IH_Invitation_QB on(null|string $connection = null)
     * @method static _IH_Invitation_QB query()
     * @method static _IH_Invitation_QB with(array|string $relations)
     * @method _IH_Invitation_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Invitation_C|Invitation[] all()
     * @mixin _IH_Invitation_QB
     */
    class Invitation extends Model {}
    
    /**
     * @property string $id
     * @property string $type
     * @property int $notifiable_id
     * @property string $notifiable_type
     * @property array $data
     * @property Carbon|null $read_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $lms_id
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_Notification_QB onWriteConnection()
     * @method _IH_Notification_QB newQuery()
     * @method static _IH_Notification_QB on(null|string $connection = null)
     * @method static _IH_Notification_QB query()
     * @method static _IH_Notification_QB with(array|string $relations)
     * @method _IH_Notification_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Notification_C|Notification[] all()
     * @mixin _IH_Notification_QB
     */
    class Notification extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $lms_id
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Status_QB onWriteConnection()
     * @method _IH_Status_QB newQuery()
     * @method static _IH_Status_QB on(null|string $connection = null)
     * @method static _IH_Status_QB query()
     * @method static _IH_Status_QB with(array|string $relations)
     * @method _IH_Status_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Status_C|Status[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_Status_QB
     */
    class Status extends Model {}
}