<?php //6144b11c6679e5fbac1144f8d2d746af
/** @noinspection all */

namespace Modules\BundleSubscription\Entities {

    use App\Models\LmsInstitute;
    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\BundleSubscription\Entities\_IH_BundleCoursePlan_C;
    use LaravelIdea\Helper\Modules\BundleSubscription\Entities\_IH_BundleCoursePlan_QB;
    use LaravelIdea\Helper\Modules\BundleSubscription\Entities\_IH_BundleCourse_C;
    use LaravelIdea\Helper\Modules\BundleSubscription\Entities\_IH_BundleCourse_QB;
    use LaravelIdea\Helper\Modules\BundleSubscription\Entities\_IH_BundleReveiw_C;
    use LaravelIdea\Helper\Modules\BundleSubscription\Entities\_IH_BundleReveiw_QB;
    use LaravelIdea\Helper\Modules\BundleSubscription\Entities\_IH_BundleSetting_C;
    use LaravelIdea\Helper\Modules\BundleSubscription\Entities\_IH_BundleSetting_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use Modules\CourseSetting\Entities\Course;
    
    /**
     * @property int $id
     * @property int $plan_id
     * @property int $course_id
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Course $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property BundleCoursePlan $plan
     * @method BelongsTo|_IH_BundleCoursePlan_QB plan()
     * @method static _IH_BundleCourse_QB onWriteConnection()
     * @method _IH_BundleCourse_QB newQuery()
     * @method static _IH_BundleCourse_QB on(null|string $connection = null)
     * @method static _IH_BundleCourse_QB query()
     * @method static _IH_BundleCourse_QB with(array|string $relations)
     * @method _IH_BundleCourse_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_BundleCourse_C|BundleCourse[] all()
     * @ownLinks course_id,\Modules\CourseSetting\Entities\Course,id
     * @foreignLinks id,\Modules\CourseSetting\Entities\CourseEnrolled,bundle_course_id|id,\Modules\Payment\Entities\Cart,bundle_course_id
     * @mixin _IH_BundleCourse_QB
     */
    class BundleCourse extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property float $price
     * @property string|null $about
     * @property int|null $days
     * @property bool $status
     * @property int $order
     * @property string $button_text
     * @property int $student
     * @property int $user_id
     * @property int $reveune
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read array $star_wise_review attribute
     * @property _IH_BundleCourse_C|BundleCourse[] $course
     * @property-read int $course_count
     * @method HasMany|_IH_BundleCourse_QB course()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property _IH_BundleReveiw_C|BundleReveiw[] $reviews
     * @property-read int $reviews_count
     * @method HasMany|_IH_BundleReveiw_QB reviews()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_BundleCoursePlan_QB onWriteConnection()
     * @method _IH_BundleCoursePlan_QB newQuery()
     * @method static _IH_BundleCoursePlan_QB on(null|string $connection = null)
     * @method static _IH_BundleCoursePlan_QB query()
     * @method static _IH_BundleCoursePlan_QB with(array|string $relations)
     * @method _IH_BundleCoursePlan_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_BundleCoursePlan_C|BundleCoursePlan[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_BundleCoursePlan_QB
     */
    class BundleCoursePlan extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $bundle_id
     * @property bool $status
     * @property string $comment
     * @property float $star
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property BundleCoursePlan $plan
     * @method BelongsTo|_IH_BundleCoursePlan_QB plan()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_BundleReveiw_QB onWriteConnection()
     * @method _IH_BundleReveiw_QB newQuery()
     * @method static _IH_BundleReveiw_QB on(null|string $connection = null)
     * @method static _IH_BundleReveiw_QB query()
     * @method static _IH_BundleReveiw_QB with(array|string $relations)
     * @method _IH_BundleReveiw_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_BundleReveiw_C|BundleReveiw[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_BundleReveiw_QB
     */
    class BundleReveiw extends Model {}
    
    /**
     * @property int $id
     * @property int $commission_rate
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_BundleSetting_QB onWriteConnection()
     * @method _IH_BundleSetting_QB newQuery()
     * @method static _IH_BundleSetting_QB on(null|string $connection = null)
     * @method static _IH_BundleSetting_QB query()
     * @method static _IH_BundleSetting_QB with(array|string $relations)
     * @method _IH_BundleSetting_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_BundleSetting_C|BundleSetting[] all()
     * @mixin _IH_BundleSetting_QB
     */
    class BundleSetting extends Model {}
}