<?php //05afdbcd7eb9e197a7e94612af0793fe
/** @noinspection all */

namespace Modules\Gift\Entities {

    use App\Models\LmsInstitute;
    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_Schedule_QB;
    use LaravelIdea\Helper\Modules\BundleSubscription\Entities\_IH_BundleCoursePlan_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use LaravelIdea\Helper\Modules\Gift\Entities\_IH_GiftCart_C;
    use LaravelIdea\Helper\Modules\Gift\Entities\_IH_GiftCart_QB;
    use LaravelIdea\Helper\Modules\Gift\Entities\_IH_GiftRecord_C;
    use LaravelIdea\Helper\Modules\Gift\Entities\_IH_GiftRecord_QB;
    use Modules\Appointment\Entities\Schedule;
    use Modules\BundleSubscription\Entities\BundleCoursePlan;
    use Modules\CourseSetting\Entities\Course;
    
    /**
     * @property int $id
     * @property int $course_id
     * @property int $user_id
     * @property int $instructor_id
     * @property string $tracking
     * @property float $price
     * @property int $gift_id
     * @property int $is_gift
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property BundleCoursePlan $bundle
     * @method BelongsTo|_IH_BundleCoursePlan_QB bundle()
     * @property GiftRecord $cart_gift
     * @method BelongsTo|_IH_GiftRecord_QB cart_gift()
     * @property Course $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property User $instructor
     * @method BelongsTo|_IH_User_QB instructor()
     * @property Schedule $schedule
     * @method BelongsTo|_IH_Schedule_QB schedule()
     * @property User $student
     * @method BelongsTo|_IH_User_QB student()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_GiftCart_QB onWriteConnection()
     * @method _IH_GiftCart_QB newQuery()
     * @method static _IH_GiftCart_QB on(null|string $connection = null)
     * @method static _IH_GiftCart_QB query()
     * @method static _IH_GiftCart_QB with(array|string $relations)
     * @method _IH_GiftCart_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_GiftCart_C|GiftCart[] all()
     * @ownLinks course_id,\Modules\CourseSetting\Entities\Course,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_GiftCart_QB
     */
    class GiftCart extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $course_id
     * @property string|null $gift_user_email
     * @property string|null $gift_send_time
     * @property string|null $gift_receiver_name
     * @property int|null $gift_receiver_id
     * @property string|null $gift_message
     * @property string|null $gift_status
     * @property int|null $cart_id
     * @property float|null $price
     * @property array|null $checkout_data
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read string $status attribute
     * @property Course $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property User|null $receiver
     * @method BelongsTo|_IH_User_QB receiver()
     * @property User $sender
     * @method BelongsTo|_IH_User_QB sender()
     * @method static _IH_GiftRecord_QB onWriteConnection()
     * @method _IH_GiftRecord_QB newQuery()
     * @method static _IH_GiftRecord_QB on(null|string $connection = null)
     * @method static _IH_GiftRecord_QB query()
     * @method static _IH_GiftRecord_QB with(array|string $relations)
     * @method _IH_GiftRecord_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_GiftRecord_C|GiftRecord[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|course_id,\Modules\CourseSetting\Entities\Course,id|cart_id,\Modules\Payment\Entities\Cart,id
     * @mixin _IH_GiftRecord_QB
     */
    class GiftRecord extends Model {}
}