<?php //ae3d8021e261127640a5284c123da98d
/** @noinspection all */

namespace Modules\Group\Entities {

    use App\Models\LmsInstitute;
    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use LaravelIdea\Helper\Modules\Group\Entities\_IH_GroupMember_C;
    use LaravelIdea\Helper\Modules\Group\Entities\_IH_GroupMember_QB;
    use LaravelIdea\Helper\Modules\Group\Entities\_IH_Group_C;
    use LaravelIdea\Helper\Modules\Group\Entities\_IH_Group_QB;
    use LaravelIdea\Helper\Modules\RolePermission\Entities\_IH_Role_QB;
    use Modules\CourseSetting\Entities\Course;
    use Modules\RolePermission\Entities\Role;
    
    /**
     * @property int $id
     * @property string|null $name
     * @property Carbon|null $date_it_is_taught
     * @property Carbon|null $end_date
     * @property int|null $minimum_enroll
     * @property int|null $maximum_enroll
     * @property int|null $type
     * @property string|null $company_code
     * @property bool $group_status
     * @property bool $cancel_status
     * @property bool $publication_status
     * @property bool $quota_status
     * @property string|null $content_validity
     * @property int|null $days_to_cancel
     * @property string|null $webinar_link
     * @property int|null $course_id
     * @property int $created_by
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $membership_level_id
     * @property Course|null $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property _IH_GroupMember_C|GroupMember[] $members
     * @property-read int $members_count
     * @method HasMany|_IH_GroupMember_QB members()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Group_QB onWriteConnection()
     * @method _IH_Group_QB newQuery()
     * @method static _IH_Group_QB on(null|string $connection = null)
     * @method static _IH_Group_QB query()
     * @method static _IH_Group_QB with(array|string $relations)
     * @method _IH_Group_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Group_C|Group[] all()
     * @ownLinks course_id,\Modules\CourseSetting\Entities\Course,id|membership_level_id,\Modules\Membership\Entities\MembershipLevel,id
     * @foreignLinks id,\Modules\Group\Entities\GroupMember,group_id|id,\Modules\Quiz\Entities\OnlineQuiz,group_id|id,\Modules\Chat\Entities\GroupUser,group_id|id,\Modules\Chat\Entities\GroupMessageRecipient,group_id|id,\Modules\Homework\Entities\InfixHomework,group_id|id,\Modules\Forum\Entities\Forum,group_id|id,\Modules\Survey\Entities\Survey,group_id|id,\Modules\SkillAndPathway\Entities\GroupStudent,group_id|id,\Modules\Survey\Entities\SurveyQuestionBank,group_id|id,\Modules\ELibrary\Entities\EbookAccess,group_id|id,\Modules\Membership\Entities\LevelGroupMember,group_id|id,\Modules\AdvanceQuiz\Entities\OnlineQuizGroupAssign,group_id
     * @mixin _IH_Group_QB
     */
    class Group extends Model {}
    
    /**
     * @property int $id
     * @property int $group_id
     * @property int $user_id
     * @property int|null $user_role_id
     * @property string|null $instructor_role
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $membership_level_id
     * @property Group $group
     * @method BelongsTo|_IH_Group_QB group()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property Role|null $role
     * @method BelongsTo|_IH_Role_QB role()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_GroupMember_QB onWriteConnection()
     * @method _IH_GroupMember_QB newQuery()
     * @method static _IH_GroupMember_QB on(null|string $connection = null)
     * @method static _IH_GroupMember_QB query()
     * @method static _IH_GroupMember_QB with(array|string $relations)
     * @method _IH_GroupMember_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_GroupMember_C|GroupMember[] all()
     * @ownLinks group_id,\Modules\Group\Entities\Group,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|user_role_id,\Modules\UserType\Entities\UserRole,id|membership_level_id,\Modules\Membership\Entities\MembershipLevel,id
     * @mixin _IH_GroupMember_QB
     */
    class GroupMember extends Model {}
}