<?php //e8b0d2dce2cddab114ff188891bee00b
/** @noinspection all */

namespace Modules\Coupons\Entities {

    use App\Models\LmsInstitute;
    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\Coupons\Entities\_IH_Coupon_C;
    use LaravelIdea\Helper\Modules\Coupons\Entities\_IH_Coupon_QB;
    use LaravelIdea\Helper\Modules\Coupons\Entities\_IH_UserWiseCouponSetting_C;
    use LaravelIdea\Helper\Modules\Coupons\Entities\_IH_UserWiseCouponSetting_QB;
    use LaravelIdea\Helper\Modules\Coupons\Entities\_IH_UserWiseCoupon_C;
    use LaravelIdea\Helper\Modules\Coupons\Entities\_IH_UserWiseCoupon_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Category_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use LaravelIdea\Helper\Modules\Payment\Entities\_IH_Checkout_C;
    use LaravelIdea\Helper\Modules\Payment\Entities\_IH_Checkout_QB;
    use LaravelIdea\Helper\Modules\RolePermission\Entities\_IH_Role_QB;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_SubscriptionCheckout_C;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_SubscriptionCheckout_QB;
    use Modules\CourseSetting\Entities\Category;
    use Modules\CourseSetting\Entities\Course;
    use Modules\Payment\Entities\Checkout;
    use Modules\RolePermission\Entities\Role;
    use Modules\Subscription\Entities\SubscriptionCheckout;
    
    /**
     * @property int $id
     * @property int|null $user_id
     * @property string|null $title
     * @property string|null $code
     * @property bool $status
     * @property float|null $value
     * @property bool $type
     * @property float|null $min_purchase
     * @property float|null $max_discount
     * @property Carbon $start_date
     * @property Carbon $end_date
     * @property int $category
     * @property int|null $category_id
     * @property int|null $subcategory_id
     * @property int|null $course_id
     * @property int|null $coupon_user_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $limit
     * @property User|null $coupon_user
     * @method BelongsTo|_IH_User_QB coupon_user()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property _IH_SubscriptionCheckout_C|SubscriptionCheckout[] $loginUserTotalSubscriptionUsed
     * @property-read int $login_user_total_subscription_used_count
     * @method HasMany|_IH_SubscriptionCheckout_QB loginUserTotalSubscriptionUsed()
     * @property _IH_Checkout_C|Checkout[] $loginUserTotalUsed
     * @property-read int $login_user_total_used_count
     * @method HasMany|_IH_Checkout_QB loginUserTotalUsed()
     * @property _IH_Checkout_C|Checkout[] $totalUsed
     * @property-read int $total_used_count
     * @method HasMany|_IH_Checkout_QB totalUsed()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Coupon_QB onWriteConnection()
     * @method _IH_Coupon_QB newQuery()
     * @method static _IH_Coupon_QB on(null|string $connection = null)
     * @method static _IH_Coupon_QB query()
     * @method static _IH_Coupon_QB with(array|string $relations)
     * @method _IH_Coupon_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Coupon_C|Coupon[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|category_id,\Modules\CourseSetting\Entities\Category,id|course_id,\Modules\CourseSetting\Entities\Course,id
     * @foreignLinks id,\Modules\Payment\Entities\Checkout,coupon_id|id,\Modules\Subscription\Entities\SubscriptionCheckout,coupon_id|id,\Modules\Invoice\Entities\Invoice,coupon_id|id,\Modules\Membership\Entities\MembershipPlanCheckout,coupon_id|id,\Modules\Membership\Entities\EbookPlanCheckOut,coupon_id|id,\Modules\Membership\Entities\MembershipSubscriptionRenew,coupon_id|id,\Modules\Membership\Entities\MembershipUpgradeLevel,coupon_id
     * @mixin _IH_Coupon_QB
     */
    class Coupon extends Model {}
    
    /**
     * @property int $id
     * @property int|null $invite_by
     * @property int|null $invite_accept_by
     * @property string|null $invite_code
     * @property int|null $category_id
     * @property int|null $subcategory_id
     * @property int|null $course_id
     * @property float|null $bonus_amount
     * @property Carbon|null $date
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Category|null $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property Course|null $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property User|null $invite_accept_byF
     * @method BelongsTo|_IH_User_QB invite_accept_byF()
     * @property User|null $invite_byF
     * @method BelongsTo|_IH_User_QB invite_byF()
     * @property Category|null $subCategory
     * @method BelongsTo|_IH_Category_QB subCategory()
     * @method static _IH_UserWiseCoupon_QB onWriteConnection()
     * @method _IH_UserWiseCoupon_QB newQuery()
     * @method static _IH_UserWiseCoupon_QB on(null|string $connection = null)
     * @method static _IH_UserWiseCoupon_QB query()
     * @method static _IH_UserWiseCoupon_QB with(array|string $relations)
     * @method _IH_UserWiseCoupon_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserWiseCoupon_C|UserWiseCoupon[] all()
     * @ownLinks category_id,\Modules\CourseSetting\Entities\Category,id|course_id,\Modules\CourseSetting\Entities\Course,id
     * @mixin _IH_UserWiseCoupon_QB
     */
    class UserWiseCoupon extends Model {}
    
    /**
     * @property int $id
     * @property int|null $role_id
     * @property int|null $type
     * @property int|null $status
     * @property float|null $amount
     * @property int|null $max_limit
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property Role|null $role
     * @method BelongsTo|_IH_Role_QB role()
     * @method static _IH_UserWiseCouponSetting_QB onWriteConnection()
     * @method _IH_UserWiseCouponSetting_QB newQuery()
     * @method static _IH_UserWiseCouponSetting_QB on(null|string $connection = null)
     * @method static _IH_UserWiseCouponSetting_QB query()
     * @method static _IH_UserWiseCouponSetting_QB with(array|string $relations)
     * @method _IH_UserWiseCouponSetting_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserWiseCouponSetting_C|UserWiseCouponSetting[] all()
     * @ownLinks role_id,\Modules\RolePermission\Entities\Role,id
     * @mixin _IH_UserWiseCouponSetting_QB
     */
    class UserWiseCouponSetting extends Model {}
}