<?php //3a628cecd7f9b6e68423e32a9b5e67d3
/** @noinspection all */

namespace Modules\EarlyBird\Entities {

    use App\Models\LmsInstitute;
    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\MorphTo;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use LaravelIdea\Helper\Modules\EarlyBird\Entities\_IH_PricePlanUser_C;
    use LaravelIdea\Helper\Modules\EarlyBird\Entities\_IH_PricePlanUser_QB;
    use LaravelIdea\Helper\Modules\EarlyBird\Entities\_IH_PricePlan_C;
    use LaravelIdea\Helper\Modules\EarlyBird\Entities\_IH_PricePlan_QB;
    use Modules\CourseSetting\Entities\Course;
    
    /**
     * @property int $id
     * @property string $title
     * @property float $discount_amount
     * @property int|null $capacity
     * @property Carbon|null $start_date
     * @property Carbon|null $end_date
     * @property int|null $status
     * @property int|null $price_planable_id
     * @property string|null $price_planable_type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property Model $price_planable
     * @method MorphTo price_planable()
     * @method static _IH_PricePlan_QB onWriteConnection()
     * @method _IH_PricePlan_QB newQuery()
     * @method static _IH_PricePlan_QB on(null|string $connection = null)
     * @method static _IH_PricePlan_QB query()
     * @method static _IH_PricePlan_QB with(array|string $relations)
     * @method _IH_PricePlan_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PricePlan_C|PricePlan[] all()
     * @foreignLinks id,\Modules\Payment\Entities\Cart,price_plan_id|id,\Modules\EarlyBird\Entities\PricePlanUser,price_plan_id
     * @mixin _IH_PricePlan_QB
     */
    class PricePlan extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $price_plan_id
     * @property int $course_id
     * @property float $received_discount
     * @property bool|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read bool $is_enrolled attribute
     * @property Course $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property PricePlan $pricePlan
     * @method BelongsTo|_IH_PricePlan_QB pricePlan()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_PricePlanUser_QB onWriteConnection()
     * @method _IH_PricePlanUser_QB newQuery()
     * @method static _IH_PricePlanUser_QB on(null|string $connection = null)
     * @method static _IH_PricePlanUser_QB query()
     * @method static _IH_PricePlanUser_QB with(array|string $relations)
     * @method _IH_PricePlanUser_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PricePlanUser_C|PricePlanUser[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|price_plan_id,\Modules\EarlyBird\Entities\PricePlan,id|course_id,\Modules\CourseSetting\Entities\Course,id
     * @mixin _IH_PricePlanUser_QB
     */
    class PricePlanUser extends Model {}
}