<?php //4f7005c400f6d5ee484f7289ef813479
/** @noinspection all */

namespace Modules\StudentSetting\Entities {

    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use LaravelIdea\Helper\Modules\StudentSetting\Entities\_IH_BookmarkCourse_C;
    use LaravelIdea\Helper\Modules\StudentSetting\Entities\_IH_BookmarkCourse_QB;
    use LaravelIdea\Helper\Modules\StudentSetting\Entities\_IH_StudentImportTemporary_C;
    use LaravelIdea\Helper\Modules\StudentSetting\Entities\_IH_StudentImportTemporary_QB;
    use Modules\CourseSetting\Entities\Course;
    
    /**
     * @property int $id
     * @property int $course_id
     * @property int $user_id
     * @property int|null $lesson_id
     * @property int|null $chapter_id
     * @property string $date
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $bookmark_date attribute
     * @property Course $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_BookmarkCourse_QB onWriteConnection()
     * @method _IH_BookmarkCourse_QB newQuery()
     * @method static _IH_BookmarkCourse_QB on(null|string $connection = null)
     * @method static _IH_BookmarkCourse_QB query()
     * @method static _IH_BookmarkCourse_QB with(array|string $relations)
     * @method _IH_BookmarkCourse_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_BookmarkCourse_C|BookmarkCourse[] all()
     * @ownLinks course_id,\Modules\CourseSetting\Entities\Course,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|lesson_id,\Modules\CourseSetting\Entities\Lesson,id|chapter_id,\Modules\CourseSetting\Entities\Chapter,id
     * @mixin _IH_BookmarkCourse_QB
     */
    class BookmarkCourse extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $email
     * @property string|null $phone
     * @property string|null $dob
     * @property string|null $company
     * @property string|null $gender
     * @property string|null $student_type
     * @property string|null $identification_number
     * @property string|null $job_title
     * @property int|null $created_by
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $country
     * @method static _IH_StudentImportTemporary_QB onWriteConnection()
     * @method _IH_StudentImportTemporary_QB newQuery()
     * @method static _IH_StudentImportTemporary_QB on(null|string $connection = null)
     * @method static _IH_StudentImportTemporary_QB query()
     * @method static _IH_StudentImportTemporary_QB with(array|string $relations)
     * @method _IH_StudentImportTemporary_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_StudentImportTemporary_C|StudentImportTemporary[] all()
     * @mixin _IH_StudentImportTemporary_QB
     */
    class StudentImportTemporary extends Model {}
}