<?php //7f54e50ce7cce606637d4aa6d43155a7
/** @noinspection all */

namespace Modules\Appointment\Entities {

    use App\Models\Language;
    use App\Models\LmsInstitute;
    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_Language_QB;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_AppointmentFrontendPage_C;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_AppointmentFrontendPage_QB;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_AppointmentSettings_C;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_AppointmentSettings_QB;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_Booking_C;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_Booking_QB;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_BookTrailLesson_C;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_BookTrailLesson_QB;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_Design_C;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_Design_QB;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_InstructorCertificate_C;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_InstructorCertificate_QB;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_InstructorEducation_C;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_InstructorEducation_QB;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_InstructorReview_C;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_InstructorReview_QB;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_InstructorSocial_C;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_InstructorSocial_QB;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_InstructorTeachingCategory_C;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_InstructorTeachingCategory_QB;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_InstructorTeachingLanguage_C;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_InstructorTeachingLanguage_QB;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_InstructorWorkExperience_C;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_InstructorWorkExperience_QB;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_RequestPost_C;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_RequestPost_QB;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_Schedule_C;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_Schedule_QB;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_ShareLink_C;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_ShareLink_QB;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_Social_C;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_Social_QB;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_TimeSlot_C;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_TimeSlot_QB;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_Wishlist_C;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_Wishlist_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Category_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_CourseLevel_QB;
    use Modules\CourseSetting\Entities\Category;
    use Modules\CourseSetting\Entities\CourseLevel;
    
    /**
     * @property int $id
     * @property string|null $name
     * @property string|null $title
     * @property string|null $slug
     * @property int|null $status
     * @property int|null $position
     * @property int|null $is_default
     * @property int|null $is_static
     * @property int|null $is_page_builder
     * @property int|null $lms_id
     * @property string|null $description
     * @property string|null $type
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Design $design
     * @method BelongsTo|_IH_Design_QB design()
     * @property LmsInstitute|null $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_AppointmentFrontendPage_QB onWriteConnection()
     * @method _IH_AppointmentFrontendPage_QB newQuery()
     * @method static _IH_AppointmentFrontendPage_QB on(null|string $connection = null)
     * @method static _IH_AppointmentFrontendPage_QB query()
     * @method static _IH_AppointmentFrontendPage_QB with(array|string $relations)
     * @method _IH_AppointmentFrontendPage_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AppointmentFrontendPage_C|AppointmentFrontendPage[] all()
     * @ownLinks lms_id,\App\Models\LmsInstitute,id
     * @mixin _IH_AppointmentFrontendPage_QB
     */
    class AppointmentFrontendPage extends Model {}
    
    /**
     * @property int $id
     * @property int|null $access
     * @property int|null $lesson_booked
     * @property int|null $popular
     * @property int|null $trail_lesson
     * @property int|null $review_option
     * @property int|null $submit_review
     * @property int|null $link_after_submit
     * @property int|null $status_admin
     * @property int|null $number_of_student
     * @property int|null $user_id
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_AppointmentSettings_QB onWriteConnection()
     * @method _IH_AppointmentSettings_QB newQuery()
     * @method static _IH_AppointmentSettings_QB on(null|string $connection = null)
     * @method static _IH_AppointmentSettings_QB query()
     * @method static _IH_AppointmentSettings_QB with(array|string $relations)
     * @method _IH_AppointmentSettings_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AppointmentSettings_C|AppointmentSettings[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_AppointmentSettings_QB
     */
    class AppointmentSettings extends Model {}
    
    /**
     * @property int $id
     * @property int|null $instructor_id
     * @property int|null $student_id
     * @property string|null $share_link
     * @property int|null $schedule_id
     * @property int|null $status
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property User|null $instructorInfo
     * @method BelongsTo|_IH_User_QB instructorInfo()
     * @property Schedule|null $schedule
     * @method BelongsTo|_IH_Schedule_QB schedule()
     * @property User|null $userInfo
     * @method BelongsTo|_IH_User_QB userInfo()
     * @method static _IH_BookTrailLesson_QB onWriteConnection()
     * @method _IH_BookTrailLesson_QB newQuery()
     * @method static _IH_BookTrailLesson_QB on(null|string $connection = null)
     * @method static _IH_BookTrailLesson_QB query()
     * @method static _IH_BookTrailLesson_QB with(array|string $relations)
     * @method _IH_BookTrailLesson_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_BookTrailLesson_C|BookTrailLesson[] all()
     * @ownLinks schedule_id,\Modules\Appointment\Entities\Schedule,id
     * @mixin _IH_BookTrailLesson_QB
     */
    class BookTrailLesson extends Model {}
    
    /**
     * @property int $id
     * @property string|null $tracking
     * @property int|null $user_id
     * @property int|null $instructor_id
     * @property int|null $slot_id
     * @property int|null $schedule_id
     * @property float $purchase_price
     * @property string|null $coupon
     * @property float $discount_amount
     * @property bool $status
     * @property float $revenue
     * @property string|null $reason
     * @property string|null $type
     * @property string|null $timezone
     * @property string|null $share_link
     * @property string|null $note
     * @property int|null $payment_status
     * @property string|null $payment_type
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read void $current_student attribute
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property User|null $instructor
     * @method BelongsTo|_IH_User_QB instructor()
     * @property Schedule|null $schedule
     * @method BelongsTo|_IH_Schedule_QB schedule()
     * @property User|null $userInfo
     * @method BelongsTo|_IH_User_QB userInfo()
     * @method static _IH_Booking_QB onWriteConnection()
     * @method _IH_Booking_QB newQuery()
     * @method static _IH_Booking_QB on(null|string $connection = null)
     * @method static _IH_Booking_QB query()
     * @method static _IH_Booking_QB with(array|string $relations)
     * @method _IH_Booking_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Booking_C|Booking[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|schedule_id,\Modules\Appointment\Entities\Schedule,id
     * @foreignLinks id,\Modules\UpcomingCourse\Entities\UpcomingCourseBookingPayment,booking_id
     * @mixin _IH_Booking_QB
     */
    class Booking extends Model {}
    
    /**
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_Design_QB onWriteConnection()
     * @method _IH_Design_QB newQuery()
     * @method static _IH_Design_QB on(null|string $connection = null)
     * @method static _IH_Design_QB query()
     * @method static _IH_Design_QB with(array|string $relations)
     * @method _IH_Design_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Design_C|Design[] all()
     * @mixin _IH_Design_QB
     */
    class Design extends Model {}
    
    /**
     * @property int $id
     * @property int|null $instructor_id
     * @property string|null $duration
     * @property string|null $title
     * @property string|null $institute
     * @property int|null $is_verified
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int|null $status
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_InstructorCertificate_QB onWriteConnection()
     * @method _IH_InstructorCertificate_QB newQuery()
     * @method static _IH_InstructorCertificate_QB on(null|string $connection = null)
     * @method static _IH_InstructorCertificate_QB query()
     * @method static _IH_InstructorCertificate_QB with(array|string $relations)
     * @method _IH_InstructorCertificate_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InstructorCertificate_C|InstructorCertificate[] all()
     * @ownLinks instructor_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_InstructorCertificate_QB
     */
    class InstructorCertificate extends Model {}
    
    /**
     * @property int $id
     * @property int|null $instructor_id
     * @property string|null $duration
     * @property string|null $degree
     * @property string|null $institute
     * @property int|null $is_verified
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int|null $status
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_InstructorEducation_QB onWriteConnection()
     * @method _IH_InstructorEducation_QB newQuery()
     * @method static _IH_InstructorEducation_QB on(null|string $connection = null)
     * @method static _IH_InstructorEducation_QB query()
     * @method static _IH_InstructorEducation_QB with(array|string $relations)
     * @method _IH_InstructorEducation_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InstructorEducation_C|InstructorEducation[] all()
     * @ownLinks instructor_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_InstructorEducation_QB
     */
    class InstructorEducation extends Model {}
    
    /**
     * @property int $id
     * @property int|null $instructor_id
     * @property int|null $user_id
     * @property bool|null $status
     * @property string|null $comment
     * @property float|null $star
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read string $recent_review attribute
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property User|null $instructor
     * @method BelongsTo|_IH_User_QB instructor()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_InstructorReview_QB onWriteConnection()
     * @method _IH_InstructorReview_QB newQuery()
     * @method static _IH_InstructorReview_QB on(null|string $connection = null)
     * @method static _IH_InstructorReview_QB query()
     * @method static _IH_InstructorReview_QB with(array|string $relations)
     * @method _IH_InstructorReview_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InstructorReview_C|InstructorReview[] all()
     * @ownLinks instructor_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_InstructorReview_QB
     */
    class InstructorReview extends Model {}
    
    /**
     * @property int $id
     * @property int|null $instructor_id
     * @property string|null $icon
     * @property string|null $url
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_InstructorSocial_QB onWriteConnection()
     * @method _IH_InstructorSocial_QB newQuery()
     * @method static _IH_InstructorSocial_QB on(null|string $connection = null)
     * @method static _IH_InstructorSocial_QB query()
     * @method static _IH_InstructorSocial_QB with(array|string $relations)
     * @method _IH_InstructorSocial_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InstructorSocial_C|InstructorSocial[] all()
     * @ownLinks instructor_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_InstructorSocial_QB
     */
    class InstructorSocial extends Model {}
    
    /**
     * @property int $id
     * @property int|null $instructor_id
     * @property int|null $category_id
     * @property int|null $sub_category_id
     * @property int|null $level_id
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int|null $status
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_InstructorTeachingCategory_QB onWriteConnection()
     * @method _IH_InstructorTeachingCategory_QB newQuery()
     * @method static _IH_InstructorTeachingCategory_QB on(null|string $connection = null)
     * @method static _IH_InstructorTeachingCategory_QB query()
     * @method static _IH_InstructorTeachingCategory_QB with(array|string $relations)
     * @method _IH_InstructorTeachingCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InstructorTeachingCategory_C|InstructorTeachingCategory[] all()
     * @ownLinks instructor_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|category_id,\Modules\CourseSetting\Entities\Category,id|sub_category_id,\Modules\CourseSetting\Entities\SubCategory,id
     * @mixin _IH_InstructorTeachingCategory_QB
     */
    class InstructorTeachingCategory extends Model {}
    
    /**
     * @property int $id
     * @property int|null $instructor_id
     * @property int|null $language_id
     * @property int|null $level_id
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int|null $status
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property Language|null $language
     * @method BelongsTo|_IH_Language_QB language()
     * @property CourseLevel|null $level
     * @method BelongsTo|_IH_CourseLevel_QB level()
     * @method static _IH_InstructorTeachingLanguage_QB onWriteConnection()
     * @method _IH_InstructorTeachingLanguage_QB newQuery()
     * @method static _IH_InstructorTeachingLanguage_QB on(null|string $connection = null)
     * @method static _IH_InstructorTeachingLanguage_QB query()
     * @method static _IH_InstructorTeachingLanguage_QB with(array|string $relations)
     * @method _IH_InstructorTeachingLanguage_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InstructorTeachingLanguage_C|InstructorTeachingLanguage[] all()
     * @ownLinks instructor_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|language_id,\Modules\Localization\Entities\Language,id
     * @mixin _IH_InstructorTeachingLanguage_QB
     */
    class InstructorTeachingLanguage extends Model {}
    
    /**
     * @property int $id
     * @property int|null $instructor_id
     * @property string|null $duration
     * @property string|null $designation
     * @property string|null $institute
     * @property int|null $is_verified
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int|null $status
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_InstructorWorkExperience_QB onWriteConnection()
     * @method _IH_InstructorWorkExperience_QB newQuery()
     * @method static _IH_InstructorWorkExperience_QB on(null|string $connection = null)
     * @method static _IH_InstructorWorkExperience_QB query()
     * @method static _IH_InstructorWorkExperience_QB with(array|string $relations)
     * @method _IH_InstructorWorkExperience_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InstructorWorkExperience_C|InstructorWorkExperience[] all()
     * @ownLinks instructor_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_InstructorWorkExperience_QB
     */
    class InstructorWorkExperience extends Model {}
    
    /**
     * @property int $id
     * @property int|null $teaching_category
     * @property string|null $headline
     * @property string|null $requirement
     * @property int|null $user_id
     * @property int|null $min_price
     * @property int|null $max_price
     * @property string|null $name
     * @property string|null $email
     * @property int|null $status
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Category|null $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property User|null $userInfo
     * @method BelongsTo|_IH_User_QB userInfo()
     * @method static _IH_RequestPost_QB onWriteConnection()
     * @method _IH_RequestPost_QB newQuery()
     * @method static _IH_RequestPost_QB on(null|string $connection = null)
     * @method static _IH_RequestPost_QB query()
     * @method static _IH_RequestPost_QB with(array|string $relations)
     * @method _IH_RequestPost_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RequestPost_C|RequestPost[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_RequestPost_QB
     */
    class RequestPost extends Model {}
    
    /**
     * @property int $id
     * @property Carbon|null $schedule_date
     * @property string|null $day
     * @property Carbon|null $start_date
     * @property Carbon|null $end_date
     * @property int|null $slot_id
     * @property int|null $user_id
     * @property int|null $total_booked
     * @property float $revenue
     * @property float|null $discount_price
     * @property int|null $category_id
     * @property int|null $sub_category_id
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int|null $special_commission
     * @property int|null $status
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Booking_C|Booking[] $activeBooked
     * @property-read int $active_booked_count
     * @method HasMany|_IH_Booking_QB activeBooked()
     * @property _IH_Booking_C|Booking[] $booked
     * @property-read int $booked_count
     * @method HasMany|_IH_Booking_QB booked()
     * @property Category|null $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property _IH_Booking_C|Booking[] $instructorBookedUser
     * @property-read int $instructor_booked_user_count
     * @method HasMany|_IH_Booking_QB instructorBookedUser()
     * @property TimeSlot|null $slotInfo
     * @method BelongsTo|_IH_TimeSlot_QB slotInfo()
     * @property Category|null $subCategory
     * @method BelongsTo|_IH_Category_QB subCategory()
     * @property User|null $userInfo
     * @method BelongsTo|_IH_User_QB userInfo()
     * @method static _IH_Schedule_QB onWriteConnection()
     * @method _IH_Schedule_QB newQuery()
     * @method static _IH_Schedule_QB on(null|string $connection = null)
     * @method static _IH_Schedule_QB query()
     * @method static _IH_Schedule_QB with(array|string $relations)
     * @method _IH_Schedule_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Schedule_C|Schedule[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|category_id,\Modules\CourseSetting\Entities\Category,id|sub_category_id,\Modules\CourseSetting\Entities\SubCategory,id
     * @foreignLinks id,\Modules\Payment\Entities\Cart,schedule_id|id,\Modules\Appointment\Entities\Booking,schedule_id|id,\Modules\Appointment\Entities\ShareLink,schedule_id|id,\Modules\Appointment\Entities\BookTrailLesson,schedule_id
     * @mixin _IH_Schedule_QB
     */
    class Schedule extends Model {}
    
    /**
     * @property int $id
     * @property int|null $status
     * @property string|null $link
     * @property string|null $note
     * @property int|null $schedule_id
     * @property int|null $student_id
     * @property int|null $type
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_ShareLink_QB onWriteConnection()
     * @method _IH_ShareLink_QB newQuery()
     * @method static _IH_ShareLink_QB on(null|string $connection = null)
     * @method static _IH_ShareLink_QB query()
     * @method static _IH_ShareLink_QB with(array|string $relations)
     * @method _IH_ShareLink_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ShareLink_C|ShareLink[] all()
     * @ownLinks schedule_id,\Modules\Appointment\Entities\Schedule,id
     * @mixin _IH_ShareLink_QB
     */
    class ShareLink extends Model {}
    
    /**
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_Social_QB onWriteConnection()
     * @method _IH_Social_QB newQuery()
     * @method static _IH_Social_QB on(null|string $connection = null)
     * @method static _IH_Social_QB query()
     * @method static _IH_Social_QB with(array|string $relations)
     * @method _IH_Social_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Social_C|Social[] all()
     * @mixin _IH_Social_QB
     */
    class Social extends Model {}
    
    /**
     * @property int $id
     * @property string|null $type
     * @property string|null $title
     * @property Carbon|null $start_time
     * @property Carbon|null $end_time
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int|null $user_id
     * @property int|null $status
     * @property int|null $is_break
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read string $duration attribute
     * @property-read string $start_to_end attribute
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property User|null $instructor
     * @method BelongsTo|_IH_User_QB instructor()
     * @method static _IH_TimeSlot_QB onWriteConnection()
     * @method _IH_TimeSlot_QB newQuery()
     * @method static _IH_TimeSlot_QB on(null|string $connection = null)
     * @method static _IH_TimeSlot_QB query()
     * @method static _IH_TimeSlot_QB with(array|string $relations)
     * @method _IH_TimeSlot_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TimeSlot_C|TimeSlot[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_TimeSlot_QB
     */
    class TimeSlot extends Model {}
    
    /**
     * @property int $id
     * @property int|null $instructor_id
     * @property int|null $user_id
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property User|null $instructor
     * @method BelongsTo|_IH_User_QB instructor()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Wishlist_QB onWriteConnection()
     * @method _IH_Wishlist_QB newQuery()
     * @method static _IH_Wishlist_QB on(null|string $connection = null)
     * @method static _IH_Wishlist_QB query()
     * @method static _IH_Wishlist_QB with(array|string $relations)
     * @method _IH_Wishlist_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Wishlist_C|Wishlist[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_Wishlist_QB
     */
    class Wishlist extends Model {}
}