<?php //375da9f00563e849d15999d24f8cdff1
/** @noinspection all */

namespace Modules\Survey\Entities {

    use App\Models\LmsInstitute;
    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Category_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use LaravelIdea\Helper\Modules\Org\Entities\_IH_OrgSurveyBranch_C;
    use LaravelIdea\Helper\Modules\Org\Entities\_IH_OrgSurveyBranch_QB;
    use LaravelIdea\Helper\Modules\Org\Entities\_IH_OrgSurveyPosition_C;
    use LaravelIdea\Helper\Modules\Org\Entities\_IH_OrgSurveyPosition_QB;
    use LaravelIdea\Helper\Modules\Survey\Entities\_IH_SurveyAnswerSubmit_C;
    use LaravelIdea\Helper\Modules\Survey\Entities\_IH_SurveyAnswerSubmit_QB;
    use LaravelIdea\Helper\Modules\Survey\Entities\_IH_SurveyAssign_C;
    use LaravelIdea\Helper\Modules\Survey\Entities\_IH_SurveyAssign_QB;
    use LaravelIdea\Helper\Modules\Survey\Entities\_IH_SurveyGroup_C;
    use LaravelIdea\Helper\Modules\Survey\Entities\_IH_SurveyGroup_QB;
    use LaravelIdea\Helper\Modules\Survey\Entities\_IH_SurveyQuestionAssign_C;
    use LaravelIdea\Helper\Modules\Survey\Entities\_IH_SurveyQuestionAssign_QB;
    use LaravelIdea\Helper\Modules\Survey\Entities\_IH_SurveyQuestionBankMuOption_C;
    use LaravelIdea\Helper\Modules\Survey\Entities\_IH_SurveyQuestionBankMuOption_QB;
    use LaravelIdea\Helper\Modules\Survey\Entities\_IH_SurveyQuestionBank_C;
    use LaravelIdea\Helper\Modules\Survey\Entities\_IH_SurveyQuestionBank_QB;
    use LaravelIdea\Helper\Modules\Survey\Entities\_IH_SurveyQuestionSetAttribute_C;
    use LaravelIdea\Helper\Modules\Survey\Entities\_IH_SurveyQuestionSetAttribute_QB;
    use LaravelIdea\Helper\Modules\Survey\Entities\_IH_SurveyQuestionSet_C;
    use LaravelIdea\Helper\Modules\Survey\Entities\_IH_SurveyQuestionSet_QB;
    use LaravelIdea\Helper\Modules\Survey\Entities\_IH_SurveyQuestion_C;
    use LaravelIdea\Helper\Modules\Survey\Entities\_IH_SurveyQuestion_QB;
    use LaravelIdea\Helper\Modules\Survey\Entities\_IH_Survey_C;
    use LaravelIdea\Helper\Modules\Survey\Entities\_IH_Survey_QB;
    use Modules\CourseSetting\Entities\Category;
    use Modules\CourseSetting\Entities\Course;
    use Modules\Org\Entities\OrgSurveyBranch;
    use Modules\Org\Entities\OrgSurveyPosition;
    
    /**
     * @property int $id
     * @property string $title
     * @property string|null $description
     * @property bool|null $set_time
     * @property string|null $publish_date
     * @property string|null $publish_time
     * @property int|null $status
     * @property int|null $created_by
     * @property string|null $survey_for
     * @property int|null $assign_to
     * @property int|null $group_id
     * @property int|null $course_id
     * @property int|null $role_id
     * @property int|null $is_published
     * @property int|null $is_anonymous
     * @property string|null $users_id
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $category_id
     * @property int $survey_type
     * @property int $audience
     * @property int $position_audience
     * @property string|null $deadline_date
     * @property string|null $deadline_time
     * @property int $org_leaderboard_point
     * @property-read $is_publish attribute
     * @property _IH_SurveyAssign_C|SurveyAssign[] $assigns
     * @property-read int $assigns_count
     * @method HasMany|_IH_SurveyAssign_QB assigns()
     * @property _IH_OrgSurveyBranch_C|OrgSurveyBranch[] $branches
     * @property-read int $branches_count
     * @method HasMany|_IH_OrgSurveyBranch_QB branches()
     * @property Course|null $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property _IH_SurveyAnswerSubmit_C|SurveyAnswerSubmit[] $participants
     * @property-read int $participants_count
     * @method HasMany|_IH_SurveyAnswerSubmit_QB participants()
     * @property _IH_OrgSurveyPosition_C|OrgSurveyPosition[] $positions
     * @property-read int $positions_count
     * @method HasMany|_IH_OrgSurveyPosition_QB positions()
     * @property _IH_SurveyQuestionAssign_C|SurveyQuestionAssign[] $questionAssigns
     * @property-read int $question_assigns_count
     * @method HasMany|_IH_SurveyQuestionAssign_QB questionAssigns()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Survey_QB onWriteConnection()
     * @method _IH_Survey_QB newQuery()
     * @method static _IH_Survey_QB on(null|string $connection = null)
     * @method static _IH_Survey_QB query()
     * @method static _IH_Survey_QB with(array|string $relations)
     * @method _IH_Survey_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Survey_C|Survey[] all()
     * @ownLinks group_id,\Modules\Group\Entities\Group,id|course_id,\Modules\CourseSetting\Entities\Course,id|role_id,\Modules\RolePermission\Entities\Role,id|users_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|category_id,\Modules\CourseSetting\Entities\Category,id
     * @foreignLinks id,\Modules\Survey\Entities\SurveyAssign,survey_id|id,\Modules\Survey\Entities\SurveyQuestion,survey_id|id,\Modules\Survey\Entities\SurveyAnswerSubmit,survey_id|id,\Modules\Org\Entities\OrgSurveyPosition,survey_id|id,\Modules\Org\Entities\OrgSurveyBranch,survey_id|id,\Modules\Survey\Entities\SurveyQuestionAssign,survey_id|id,\Modules\Org\Entities\OrgLeaderboardUserPoint,survey_id
     * @mixin _IH_Survey_QB
     */
    class Survey extends Model {}
    
    /**
     * @property int $id
     * @property int $assign_id
     * @property int $survey_id
     * @property int $user_id
     * @property int $question_id
     * @property int|null $attribute_id
     * @property string|null $answer
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property SurveyQuestionSetAttribute|null $attribute
     * @method BelongsTo|_IH_SurveyQuestionSetAttribute_QB attribute()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property SurveyQuestionBankMuOption|null $questionMu
     * @method BelongsTo|_IH_SurveyQuestionBankMuOption_QB questionMu()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_SurveyAnswerSubmit_QB onWriteConnection()
     * @method _IH_SurveyAnswerSubmit_QB newQuery()
     * @method static _IH_SurveyAnswerSubmit_QB on(null|string $connection = null)
     * @method static _IH_SurveyAnswerSubmit_QB query()
     * @method static _IH_SurveyAnswerSubmit_QB with(array|string $relations)
     * @method _IH_SurveyAnswerSubmit_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SurveyAnswerSubmit_C|SurveyAnswerSubmit[] all()
     * @ownLinks survey_id,\Modules\Survey\Entities\Survey,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_SurveyAnswerSubmit_QB
     */
    class SurveyAnswerSubmit extends Model {}
    
    /**
     * @property int $id
     * @property int $survey_id
     * @property int $user_id
     * @property int|null $is_attended
     * @property int|null $is_anonymous
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property _IH_SurveyQuestionBank_C|SurveyQuestionBank[] $questions
     * @property-read int $questions_count
     * @method HasMany|_IH_SurveyQuestionBank_QB questions()
     * @property Survey $survey
     * @method BelongsTo|_IH_Survey_QB survey()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_SurveyAssign_QB onWriteConnection()
     * @method _IH_SurveyAssign_QB newQuery()
     * @method static _IH_SurveyAssign_QB on(null|string $connection = null)
     * @method static _IH_SurveyAssign_QB query()
     * @method static _IH_SurveyAssign_QB with(array|string $relations)
     * @method _IH_SurveyAssign_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SurveyAssign_C|SurveyAssign[] all()
     * @ownLinks survey_id,\Modules\Survey\Entities\Survey,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_SurveyAssign_QB
     */
    class SurveyAssign extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_SurveyGroup_QB onWriteConnection()
     * @method _IH_SurveyGroup_QB newQuery()
     * @method static _IH_SurveyGroup_QB on(null|string $connection = null)
     * @method static _IH_SurveyGroup_QB query()
     * @method static _IH_SurveyGroup_QB with(array|string $relations)
     * @method _IH_SurveyGroup_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SurveyGroup_C|SurveyGroup[] all()
     * @mixin _IH_SurveyGroup_QB
     */
    class SurveyGroup extends Model {}
    
    /**
     * @property int $id
     * @property int $survey_id
     * @property string $title
     * @property string $answer_type
     * @property int|null $answer_set
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property SurveyQuestionSet|null $set
     * @method BelongsTo|_IH_SurveyQuestionSet_QB set()
     * @method static _IH_SurveyQuestion_QB onWriteConnection()
     * @method _IH_SurveyQuestion_QB newQuery()
     * @method static _IH_SurveyQuestion_QB on(null|string $connection = null)
     * @method static _IH_SurveyQuestion_QB query()
     * @method static _IH_SurveyQuestion_QB with(array|string $relations)
     * @method _IH_SurveyQuestion_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SurveyQuestion_C|SurveyQuestion[] all()
     * @ownLinks survey_id,\Modules\Survey\Entities\Survey,id
     * @mixin _IH_SurveyQuestion_QB
     */
    class SurveyQuestion extends Model {}
    
    /**
     * @property int $id
     * @property int|null $survey_id
     * @property int|null $question_bank_id
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property SurveyQuestionBank|null $questionBank
     * @method BelongsTo|_IH_SurveyQuestionBank_QB questionBank()
     * @method static _IH_SurveyQuestionAssign_QB onWriteConnection()
     * @method _IH_SurveyQuestionAssign_QB newQuery()
     * @method static _IH_SurveyQuestionAssign_QB on(null|string $connection = null)
     * @method static _IH_SurveyQuestionAssign_QB query()
     * @method static _IH_SurveyQuestionAssign_QB with(array|string $relations)
     * @method _IH_SurveyQuestionAssign_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SurveyQuestionAssign_C|SurveyQuestionAssign[] all()
     * @ownLinks survey_id,\Modules\Survey\Entities\Survey,id|question_bank_id,\Modules\Quiz\Entities\QuestionBank,id
     * @mixin _IH_SurveyQuestionAssign_QB
     */
    class SurveyQuestionAssign extends Model {}
    
    /**
     * @property int $id
     * @property string $type
     * @property string|null $question
     * @property int|null $number_of_option
     * @property int|null $group_id
     * @property int|null $category_id
     * @property int|null $sub_category_id
     * @property string|null $image
     * @property int $status
     * @property int $user_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Category|null $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property SurveyGroup|null $group
     * @method BelongsTo|_IH_SurveyGroup_QB group()
     * @property _IH_SurveyQuestionBankMuOption_C|SurveyQuestionBankMuOption[] $questionMu
     * @property-read int $question_mu_count
     * @method HasMany|_IH_SurveyQuestionBankMuOption_QB questionMu()
     * @property _IH_SurveyQuestionBankMuOption_C|SurveyQuestionBankMuOption[] $questionMuRand
     * @property-read int $question_mu_rand_count
     * @method HasMany|_IH_SurveyQuestionBankMuOption_QB questionMuRand()
     * @property Category|null $subCategory
     * @method BelongsTo|_IH_Category_QB subCategory()
     * @method static _IH_SurveyQuestionBank_QB onWriteConnection()
     * @method _IH_SurveyQuestionBank_QB newQuery()
     * @method static _IH_SurveyQuestionBank_QB on(null|string $connection = null)
     * @method static _IH_SurveyQuestionBank_QB query()
     * @method static _IH_SurveyQuestionBank_QB with(array|string $relations)
     * @method _IH_SurveyQuestionBank_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SurveyQuestionBank_C|SurveyQuestionBank[] all()
     * @ownLinks group_id,\Modules\Group\Entities\Group,id|category_id,\Modules\CourseSetting\Entities\Category,id|sub_category_id,\Modules\CourseSetting\Entities\SubCategory,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @foreignLinks id,\Modules\Survey\Entities\SurveyQuestionBankMuOption,survey_question_bank_id
     * @mixin _IH_SurveyQuestionBank_QB
     */
    class SurveyQuestionBank extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property int|null $survey_question_bank_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_SurveyQuestionBankMuOption_QB onWriteConnection()
     * @method _IH_SurveyQuestionBankMuOption_QB newQuery()
     * @method static _IH_SurveyQuestionBankMuOption_QB on(null|string $connection = null)
     * @method static _IH_SurveyQuestionBankMuOption_QB query()
     * @method static _IH_SurveyQuestionBankMuOption_QB with(array|string $relations)
     * @method _IH_SurveyQuestionBankMuOption_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SurveyQuestionBankMuOption_C|SurveyQuestionBankMuOption[] all()
     * @ownLinks survey_question_bank_id,\Modules\Survey\Entities\SurveyQuestionBank,id
     * @mixin _IH_SurveyQuestionBankMuOption_QB
     */
    class SurveyQuestionBankMuOption extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $answer_type
     * @property int|null $status
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_SurveyQuestionSetAttribute_C|SurveyQuestionSetAttribute[] $activeAttributes
     * @property-read int $active_attributes_count
     * @method HasMany|_IH_SurveyQuestionSetAttribute_QB activeAttributes()
     * @property _IH_SurveyQuestionSetAttribute_C|SurveyQuestionSetAttribute[] $attributes
     * @property-read int $attributes_count
     * @method HasMany|_IH_SurveyQuestionSetAttribute_QB attributes()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_SurveyQuestionSet_QB onWriteConnection()
     * @method _IH_SurveyQuestionSet_QB newQuery()
     * @method static _IH_SurveyQuestionSet_QB on(null|string $connection = null)
     * @method static _IH_SurveyQuestionSet_QB query()
     * @method static _IH_SurveyQuestionSet_QB with(array|string $relations)
     * @method _IH_SurveyQuestionSet_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SurveyQuestionSet_C|SurveyQuestionSet[] all()
     * @mixin _IH_SurveyQuestionSet_QB
     */
    class SurveyQuestionSet extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property int $set_id
     * @property int|null $status
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_SurveyQuestionSetAttribute_QB onWriteConnection()
     * @method _IH_SurveyQuestionSetAttribute_QB newQuery()
     * @method static _IH_SurveyQuestionSetAttribute_QB on(null|string $connection = null)
     * @method static _IH_SurveyQuestionSetAttribute_QB query()
     * @method static _IH_SurveyQuestionSetAttribute_QB with(array|string $relations)
     * @method _IH_SurveyQuestionSetAttribute_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SurveyQuestionSetAttribute_C|SurveyQuestionSetAttribute[] all()
     * @mixin _IH_SurveyQuestionSetAttribute_QB
     */
    class SurveyQuestionSetAttribute extends Model {}
}