<?php //a499a537ebddc6f36318107dcac19473
/** @noinspection all */

namespace Modules\Homework\Entities {

    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Lesson_QB;
    use LaravelIdea\Helper\Modules\Homework\Entities\_IH_AssignHomeworkHistory_C;
    use LaravelIdea\Helper\Modules\Homework\Entities\_IH_AssignHomeworkHistory_QB;
    use LaravelIdea\Helper\Modules\Homework\Entities\_IH_InfixAssignHomework_C;
    use LaravelIdea\Helper\Modules\Homework\Entities\_IH_InfixAssignHomework_QB;
    use LaravelIdea\Helper\Modules\Homework\Entities\_IH_InfixHomework_C;
    use LaravelIdea\Helper\Modules\Homework\Entities\_IH_InfixHomework_QB;
    use LaravelIdea\Helper\Modules\Homework\Entities\_IH_InfixSubmitHomework_C;
    use LaravelIdea\Helper\Modules\Homework\Entities\_IH_InfixSubmitHomework_QB;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_OnlineQuiz_QB;
    use Modules\CourseSetting\Entities\Course;
    use Modules\CourseSetting\Entities\Lesson;
    use Modules\Quiz\Entities\OnlineQuiz;
    
    /**
     * @property int $id
     * @property int|null $homework_id
     * @property int|null $assign_to
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_AssignHomeworkHistory_QB onWriteConnection()
     * @method _IH_AssignHomeworkHistory_QB newQuery()
     * @method static _IH_AssignHomeworkHistory_QB on(null|string $connection = null)
     * @method static _IH_AssignHomeworkHistory_QB query()
     * @method static _IH_AssignHomeworkHistory_QB with(array|string $relations)
     * @method _IH_AssignHomeworkHistory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AssignHomeworkHistory_C|AssignHomeworkHistory[] all()
     * @mixin _IH_AssignHomeworkHistory_QB
     */
    class AssignHomeworkHistory extends Model {}
    
    /**
     * @property int $id
     * @property int $assignment_id
     * @property int $student_id
     * @property int $is_submittable
     * @property int $assign_history_id
     * @property int|null $pass_status
     * @property int|null $exam_take
     * @property float|null $obtain_marks
     * @property float|null $assignment_mark
     * @property float|null $quiz_mark
     * @property int|null $marked_by
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property InfixHomework $assignment
     * @method BelongsTo|_IH_InfixHomework_QB assignment()
     * @property _IH_InfixSubmitHomework_C|InfixSubmitHomework[] $assignmentSubmitted
     * @property-read int $assignment_submitted_count
     * @method HasMany|_IH_InfixSubmitHomework_QB assignmentSubmitted()
     * @property User $student
     * @method BelongsTo|_IH_User_QB student()
     * @method static _IH_InfixAssignHomework_QB onWriteConnection()
     * @method _IH_InfixAssignHomework_QB newQuery()
     * @method static _IH_InfixAssignHomework_QB on(null|string $connection = null)
     * @method static _IH_InfixAssignHomework_QB query()
     * @method static _IH_InfixAssignHomework_QB with(array|string $relations)
     * @method _IH_InfixAssignHomework_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InfixAssignHomework_C|InfixAssignHomework[] all()
     * @mixin _IH_InfixAssignHomework_QB
     */
    class InfixAssignHomework extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string|null $attachment
     * @property string $description
     * @property float|null $marks
     * @property float|null $quiz_marks
     * @property float|null $min_parcentage
     * @property Carbon|null $last_date_submission
     * @property int|null $status
     * @property int|null $created_by
     * @property int|null $assignment_from
     * @property int|null $role_id
     * @property int|null $assign_to
     * @property int|null $privacy
     * @property int|null $available_for
     * @property int|null $course_id
     * @property int|null $lesson_id
     * @property int|null $group_id
     * @property int|null $quiz_id
     * @property int|null $user_id
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_AssignHomeworkHistory_C|AssignHomeworkHistory[] $assign_info
     * @property-read int $assign_info_count
     * @method HasMany|_IH_AssignHomeworkHistory_QB assign_info()
     * @property Course|null $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property User|null $creator_info
     * @method BelongsTo|_IH_User_QB creator_info()
     * @property Lesson $lesson
     * @method BelongsTo|_IH_Lesson_QB lesson()
     * @property OnlineQuiz|null $quiz
     * @method BelongsTo|_IH_OnlineQuiz_QB quiz()
     * @method static _IH_InfixHomework_QB onWriteConnection()
     * @method _IH_InfixHomework_QB newQuery()
     * @method static _IH_InfixHomework_QB on(null|string $connection = null)
     * @method static _IH_InfixHomework_QB query()
     * @method static _IH_InfixHomework_QB with(array|string $relations)
     * @method _IH_InfixHomework_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InfixHomework_C|InfixHomework[] all()
     * @ownLinks role_id,\Modules\RolePermission\Entities\Role,id|course_id,\Modules\CourseSetting\Entities\Course,id|lesson_id,\Modules\CourseSetting\Entities\Lesson,id|group_id,\Modules\Group\Entities\Group,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_InfixHomework_QB
     */
    class InfixHomework extends Model {}
    
    /**
     * @property int $id
     * @property int $assignment_id
     * @property int|null $assign_id
     * @property int $student_id
     * @property float|null $marks
     * @property string|null $answer
     * @property string|null $file
     * @property int|null $is_marked
     * @property int|null $assignment_from
     * @property int|null $marked_by
     * @property int|null $role_id
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property InfixAssignHomework|null $assigned
     * @method BelongsTo|_IH_InfixAssignHomework_QB assigned()
     * @property User $student
     * @method BelongsTo|_IH_User_QB student()
     * @method static _IH_InfixSubmitHomework_QB onWriteConnection()
     * @method _IH_InfixSubmitHomework_QB newQuery()
     * @method static _IH_InfixSubmitHomework_QB on(null|string $connection = null)
     * @method static _IH_InfixSubmitHomework_QB query()
     * @method static _IH_InfixSubmitHomework_QB with(array|string $relations)
     * @method _IH_InfixSubmitHomework_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InfixSubmitHomework_C|InfixSubmitHomework[] all()
     * @ownLinks role_id,\Modules\RolePermission\Entities\Role,id
     * @mixin _IH_InfixSubmitHomework_QB
     */
    class InfixSubmitHomework extends Model {}
}