<?php //3e8ebf235a1038b088055c2c11a1ed59
/** @noinspection all */

namespace Modules\Zoom\Entities {

    use App\Models\LmsInstitute;
    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\VirtualClass\Entities\_IH_VirtualClass_QB;
    use LaravelIdea\Helper\Modules\Zoom\Entities\_IH_ZoomMeetingUser_C;
    use LaravelIdea\Helper\Modules\Zoom\Entities\_IH_ZoomMeetingUser_QB;
    use LaravelIdea\Helper\Modules\Zoom\Entities\_IH_ZoomMeeting_C;
    use LaravelIdea\Helper\Modules\Zoom\Entities\_IH_ZoomMeeting_QB;
    use LaravelIdea\Helper\Modules\Zoom\Entities\_IH_ZoomSetting_C;
    use LaravelIdea\Helper\Modules\Zoom\Entities\_IH_ZoomSetting_QB;
    use Modules\VirtualClass\Entities\VirtualClass;
    
    /**
     * @property int $id
     * @property int|null $class_id
     * @property int $created_by
     * @property int $instructor_id
     * @property string|null $meeting_id
     * @property string|null $password
     * @property Carbon|null $start_time
     * @property Carbon|null $end_time
     * @property string|null $topic
     * @property string|null $description
     * @property string|null $attached_file
     * @property string|null $date_of_meeting
     * @property string|null $time_of_meeting
     * @property string|null $meeting_duration
     * @property bool|null $join_before_host
     * @property bool|null $host_video
     * @property bool|null $participant_video
     * @property bool|null $mute_upon_entry
     * @property bool|null $waiting_room
     * @property string $audio
     * @property string $auto_recording
     * @property string $approval_type
     * @property bool|null $is_recurring
     * @property int|null $recurring_type
     * @property int|null $recurring_repect_day
     * @property string|null $recurring_end_date
     * @property bool $status
     * @property int|null $updated_by
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read string $current_status attribute
     * @property-read $meeting_date_time attribute
     * @property-read $meeting_end_time attribute
     * @property-read $participates_name attribute
     * @property-read string $url attribute
     * @property VirtualClass|null $class
     * @method BelongsTo|_IH_VirtualClass_QB class()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property User $instructor
     * @method BelongsTo|_IH_User_QB instructor()
     * @property _IH_ZoomMeetingUser_C|ZoomMeetingUser[] $participates
     * @property-read int $participates_count
     * @method HasMany|_IH_ZoomMeetingUser_QB participates()
     * @method static _IH_ZoomMeeting_QB onWriteConnection()
     * @method _IH_ZoomMeeting_QB newQuery()
     * @method static _IH_ZoomMeeting_QB on(null|string $connection = null)
     * @method static _IH_ZoomMeeting_QB query()
     * @method static _IH_ZoomMeeting_QB with(array|string $relations)
     * @method _IH_ZoomMeeting_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ZoomMeeting_C|ZoomMeeting[] all()
     * @mixin _IH_ZoomMeeting_QB
     */
    class ZoomMeeting extends Model {}
    
    /**
     * @property int $id
     * @property int|null $meeting_id
     * @property int|null $user_id
     * @property int $host
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_ZoomMeetingUser_QB onWriteConnection()
     * @method _IH_ZoomMeetingUser_QB newQuery()
     * @method static _IH_ZoomMeetingUser_QB on(null|string $connection = null)
     * @method static _IH_ZoomMeetingUser_QB query()
     * @method static _IH_ZoomMeetingUser_QB with(array|string $relations)
     * @method _IH_ZoomMeetingUser_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ZoomMeetingUser_C|ZoomMeetingUser[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_ZoomMeetingUser_QB
     */
    class ZoomMeetingUser extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $package_id
     * @property bool $host_video
     * @property bool $participant_video
     * @property bool $join_before_host
     * @property string $audio
     * @property string $auto_recording
     * @property int $approval_type
     * @property bool $mute_upon_entry
     * @property bool $waiting_room
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $zoom_account_id
     * @property string|null $zoom_client_id
     * @property string|null $zoom_client_secret
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_ZoomSetting_QB onWriteConnection()
     * @method _IH_ZoomSetting_QB newQuery()
     * @method static _IH_ZoomSetting_QB on(null|string $connection = null)
     * @method static _IH_ZoomSetting_QB query()
     * @method static _IH_ZoomSetting_QB with(array|string $relations)
     * @method _IH_ZoomSetting_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ZoomSetting_C|ZoomSetting[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_ZoomSetting_QB
     */
    class ZoomSetting extends Model {}
}