<?php //51117fc8f223652020a37a8fc1982d4a
/** @noinspection all */

namespace Modules\Subscription\Entities {

    use App\BillingDetails;
    use App\Models\LmsInstitute;
    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\App\_IH_BillingDetails_QB;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_CourseSubscription_C;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_CourseSubscription_QB;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_Faq_C;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_Faq_QB;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_PlanFeature_C;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_PlanFeature_QB;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_SubscriptionCart_C;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_SubscriptionCart_QB;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_SubscriptionCheckout_C;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_SubscriptionCheckout_QB;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_SubscriptionCourseList_C;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_SubscriptionCourseList_QB;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_SubscriptionCourse_C;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_SubscriptionCourse_QB;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_SubscriptionSetting_C;
    use LaravelIdea\Helper\Modules\Subscription\Entities\_IH_SubscriptionSetting_QB;
    use Modules\CourseSetting\Entities\Course;
    
    /**
     * @property int $id
     * @property string|null $title
     * @property int|null $price
     * @property string|null $about
     * @property string|null $btn_txt
     * @property int $days
     * @property int $status
     * @property int $order
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $popular
     * @property int|null $is_recurring
     * @property _IH_PlanFeature_C|PlanFeature[] $features
     * @property-read int $features_count
     * @method HasMany|_IH_PlanFeature_QB features()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_CourseSubscription_QB onWriteConnection()
     * @method _IH_CourseSubscription_QB newQuery()
     * @method static _IH_CourseSubscription_QB on(null|string $connection = null)
     * @method static _IH_CourseSubscription_QB query()
     * @method static _IH_CourseSubscription_QB with(array|string $relations)
     * @method _IH_CourseSubscription_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CourseSubscription_C|CourseSubscription[] all()
     * @mixin _IH_CourseSubscription_QB
     */
    class CourseSubscription extends Model {}
    
    /**
     * @property int $id
     * @property string|null $question
     * @property string|null $answer
     * @property int $status
     * @property int $order
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_Faq_QB onWriteConnection()
     * @method _IH_Faq_QB newQuery()
     * @method static _IH_Faq_QB on(null|string $connection = null)
     * @method static _IH_Faq_QB query()
     * @method static _IH_Faq_QB with(array|string $relations)
     * @method _IH_Faq_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Faq_C|Faq[] all()
     * @mixin _IH_Faq_QB
     */
    class Faq extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property int $status
     * @property int $order
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $plan_id
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property CourseSubscription $plan
     * @method BelongsTo|_IH_CourseSubscription_QB plan()
     * @method static _IH_PlanFeature_QB onWriteConnection()
     * @method _IH_PlanFeature_QB newQuery()
     * @method static _IH_PlanFeature_QB on(null|string $connection = null)
     * @method static _IH_PlanFeature_QB query()
     * @method static _IH_PlanFeature_QB with(array|string $relations)
     * @method _IH_PlanFeature_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PlanFeature_C|PlanFeature[] all()
     * @mixin _IH_PlanFeature_QB
     */
    class PlanFeature extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $plan_id
     * @property int $price
     * @property int $days
     * @property string $tracking
     * @property string|null $billing_detail_id
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property CourseSubscription $plan
     * @method BelongsTo|_IH_CourseSubscription_QB plan()
     * @method static _IH_SubscriptionCart_QB onWriteConnection()
     * @method _IH_SubscriptionCart_QB newQuery()
     * @method static _IH_SubscriptionCart_QB on(null|string $connection = null)
     * @method static _IH_SubscriptionCart_QB query()
     * @method static _IH_SubscriptionCart_QB with(array|string $relations)
     * @method _IH_SubscriptionCart_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SubscriptionCart_C|SubscriptionCart[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|billing_detail_id,\App\BillingDetails,id
     * @mixin _IH_SubscriptionCart_QB
     */
    class SubscriptionCart extends Model {}
    
    /**
     * @property int $id
     * @property int $billing_detail_id
     * @property string|null $tracking
     * @property int|null $user_id
     * @property int|null $plan_id
     * @property int $price
     * @property Carbon|null $start_date
     * @property Carbon|null $end_date
     * @property int $days
     * @property string|null $payment_method
     * @property string|null $response
     * @property int $status
     * @property int $lms_id
     * @property string|null $tax
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $coupon_id
     * @property float $discount
     * @property float $purchase_price
     * @property BillingDetails $billing
     * @method BelongsTo|_IH_BillingDetails_QB billing()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property CourseSubscription|null $plan
     * @method BelongsTo|_IH_CourseSubscription_QB plan()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_SubscriptionCheckout_QB onWriteConnection()
     * @method _IH_SubscriptionCheckout_QB newQuery()
     * @method static _IH_SubscriptionCheckout_QB on(null|string $connection = null)
     * @method static _IH_SubscriptionCheckout_QB query()
     * @method static _IH_SubscriptionCheckout_QB with(array|string $relations)
     * @method _IH_SubscriptionCheckout_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SubscriptionCheckout_C|SubscriptionCheckout[] all()
     * @ownLinks billing_detail_id,\App\BillingDetails,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|coupon_id,\Modules\Coupons\Entities\Coupon,id
     * @mixin _IH_SubscriptionCheckout_QB
     */
    class SubscriptionCheckout extends Model {}
    
    /**
     * @property int $id
     * @property int|null $user_id
     * @property int|null $instructor_id
     * @property int|null $course_id
     * @property int|null $revenue
     * @property int|null $checkout_id
     * @property Carbon|null $date
     * @property int $status
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property SubscriptionCheckout|null $checkout
     * @method BelongsTo|_IH_SubscriptionCheckout_QB checkout()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property User|null $instructor
     * @method BelongsTo|_IH_User_QB instructor()
     * @method static _IH_SubscriptionCourse_QB onWriteConnection()
     * @method _IH_SubscriptionCourse_QB newQuery()
     * @method static _IH_SubscriptionCourse_QB on(null|string $connection = null)
     * @method static _IH_SubscriptionCourse_QB query()
     * @method static _IH_SubscriptionCourse_QB with(array|string $relations)
     * @method _IH_SubscriptionCourse_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SubscriptionCourse_C|SubscriptionCourse[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|course_id,\Modules\CourseSetting\Entities\Course,id|checkout_id,\Modules\Payment\Entities\Checkout,id
     * @mixin _IH_SubscriptionCourse_QB
     */
    class SubscriptionCourse extends Model {}
    
    /**
     * @property int $id
     * @property int $course_id
     * @property int $plan_id
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Course $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property CourseSubscription $plan
     * @method BelongsTo|_IH_CourseSubscription_QB plan()
     * @method static _IH_SubscriptionCourseList_QB onWriteConnection()
     * @method _IH_SubscriptionCourseList_QB newQuery()
     * @method static _IH_SubscriptionCourseList_QB on(null|string $connection = null)
     * @method static _IH_SubscriptionCourseList_QB query()
     * @method static _IH_SubscriptionCourseList_QB with(array|string $relations)
     * @method _IH_SubscriptionCourseList_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SubscriptionCourseList_C|SubscriptionCourseList[] all()
     * @ownLinks course_id,\Modules\CourseSetting\Entities\Course,id
     * @mixin _IH_SubscriptionCourseList_QB
     */
    class SubscriptionCourseList extends Model {}
    
    /**
     * @property int $id
     * @property int $commission_rate
     * @property int $type
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_SubscriptionSetting_QB onWriteConnection()
     * @method _IH_SubscriptionSetting_QB newQuery()
     * @method static _IH_SubscriptionSetting_QB on(null|string $connection = null)
     * @method static _IH_SubscriptionSetting_QB query()
     * @method static _IH_SubscriptionSetting_QB with(array|string $relations)
     * @method _IH_SubscriptionSetting_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SubscriptionSetting_C|SubscriptionSetting[] all()
     * @mixin _IH_SubscriptionSetting_QB
     */
    class SubscriptionSetting extends Model {}
}