<?php //84c90c826a182129dba571464a4617c2
/** @noinspection all */

namespace Modules\CourseSetting\Entities {

    use App\BillingDetails;
    use App\LessonComplete;
    use App\Models\LmsBadge;
    use App\Models\LmsInstitute;
    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasManyThrough;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_LmsBadge_C;
    use LaravelIdea\Helper\App\Models\_IH_LmsBadge_QB;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\App\_IH_BillingDetails_QB;
    use LaravelIdea\Helper\App\_IH_LessonComplete_C;
    use LaravelIdea\Helper\App\_IH_LessonComplete_QB;
    use LaravelIdea\Helper\App\_IH_User_C;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\AdvanceQuiz\Entities\_IH_OnlineQuizTestShift_C;
    use LaravelIdea\Helper\Modules\AdvanceQuiz\Entities\_IH_OnlineQuizTestShift_QB;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_InstructorTeachingCategory_C;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_InstructorTeachingCategory_QB;
    use LaravelIdea\Helper\Modules\Assignment\Entities\_IH_InfixAssignment_C;
    use LaravelIdea\Helper\Modules\Assignment\Entities\_IH_InfixAssignment_QB;
    use LaravelIdea\Helper\Modules\BunnyStorage\Entities\_IH_BunnyLesson_QB;
    use LaravelIdea\Helper\Modules\CertificatePro\Entities\_IH_CertificateTemplate_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Category_C;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Category_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Chapter_C;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Chapter_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_CourseCanceled_C;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_CourseCanceled_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_CourseCommentReply_C;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_CourseCommentReply_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_CourseComment_C;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_CourseComment_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_CourseEnrolled_C;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_CourseEnrolled_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_CourseExercise_C;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_CourseExercise_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_CourseLevel_C;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_CourseLevel_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_CourseReveiw_C;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_CourseReveiw_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_C;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_LessonFile_C;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_LessonFile_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Lesson_C;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Lesson_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Notification_C;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Notification_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Package_C;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Package_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_SchoolSubject_C;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_SchoolSubject_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_SubCategory_C;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_SubCategory_QB;
    use LaravelIdea\Helper\Modules\CPD\Entities\_IH_AssignStudent_QB;
    use LaravelIdea\Helper\Modules\EarlyBird\Entities\_IH_PricePlan_C;
    use LaravelIdea\Helper\Modules\EarlyBird\Entities\_IH_PricePlan_QB;
    use LaravelIdea\Helper\Modules\Forum\Entities\_IH_Forum_C;
    use LaravelIdea\Helper\Modules\Forum\Entities\_IH_Forum_QB;
    use LaravelIdea\Helper\Modules\Group\Entities\_IH_Group_QB;
    use LaravelIdea\Helper\Modules\H5P\Entities\_IH_H5pContent_QB;
    use LaravelIdea\Helper\Modules\H5P\Entities\_IH_H5pReport_QB;
    use LaravelIdea\Helper\Modules\Homework\Entities\_IH_InfixHomework_C;
    use LaravelIdea\Helper\Modules\Homework\Entities\_IH_InfixHomework_QB;
    use LaravelIdea\Helper\Modules\Localization\Entities\_IH_Language_QB;
    use LaravelIdea\Helper\Modules\MyClass\Entities\_IH_ClassCourseAssignStudent_QB;
    use LaravelIdea\Helper\Modules\Org\Entities\_IH_OrgMaterial_QB;
    use LaravelIdea\Helper\Modules\OrgInstructorPolicy\Entities\_IH_OrgPolicyCategory_C;
    use LaravelIdea\Helper\Modules\OrgInstructorPolicy\Entities\_IH_OrgPolicyCategory_QB;
    use LaravelIdea\Helper\Modules\OrgSubscription\Entities\_IH_OrgAttendance_C;
    use LaravelIdea\Helper\Modules\OrgSubscription\Entities\_IH_OrgAttendance_QB;
    use LaravelIdea\Helper\Modules\OrgSubscription\Entities\_IH_OrgCourseSubscription_QB;
    use LaravelIdea\Helper\Modules\OrgSubscription\Entities\_IH_OrgSubscriptionCourseList_C;
    use LaravelIdea\Helper\Modules\OrgSubscription\Entities\_IH_OrgSubscriptionCourseList_QB;
    use LaravelIdea\Helper\Modules\Payment\Entities\_IH_Checkout_QB;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_OnlineQuiz_C;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_OnlineQuiz_QB;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_QuizTest_C;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_QuizTest_QB;
    use LaravelIdea\Helper\Modules\SkillAndPathway\Entities\_IH_Pathway_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductCategory_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_Product_QB;
    use LaravelIdea\Helper\Modules\Survey\Entities\_IH_Survey_QB;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_Message_QB;
    use LaravelIdea\Helper\Modules\VirtualClass\Entities\_IH_VirtualClass_QB;
    use LaravelIdea\Helper\Modules\WaitList\Entities\_IH_CourseWaitingList_C;
    use LaravelIdea\Helper\Modules\WaitList\Entities\_IH_CourseWaitingList_QB;
    use Modules\AdvanceQuiz\Entities\OnlineQuizTestShift;
    use Modules\Appointment\Entities\InstructorTeachingCategory;
    use Modules\Assignment\Entities\InfixAssignment;
    use Modules\BunnyStorage\Entities\BunnyLesson;
    use Modules\CertificatePro\Entities\CertificateTemplate;
    use Modules\CPD\Entities\AssignStudent;
    use Modules\EarlyBird\Entities\PricePlan;
    use Modules\Forum\Entities\Forum;
    use Modules\Group\Entities\Group;
    use Modules\H5P\Entities\H5pContent;
    use Modules\H5P\Entities\H5pReport;
    use Modules\Homework\Entities\InfixHomework;
    use Modules\Localization\Entities\Language;
    use Modules\MyClass\Entities\ClassCourseAssignStudent;
    use Modules\Org\Entities\OrgMaterial;
    use Modules\OrgInstructorPolicy\Entities\OrgPolicyCategory;
    use Modules\OrgSubscription\Entities\OrgAttendance;
    use Modules\OrgSubscription\Entities\OrgCourseSubscription;
    use Modules\OrgSubscription\Entities\OrgSubscriptionCourseList;
    use Modules\Payment\Entities\Checkout;
    use Modules\Quiz\Entities\OnlineQuiz;
    use Modules\Quiz\Entities\QuizTest;
    use Modules\SkillAndPathway\Entities\Pathway;
    use Modules\Store\Entities\Product;
    use Modules\Store\Entities\ProductCategory;
    use Modules\Survey\Entities\Survey;
    use Modules\SystemSetting\Entities\Message;
    use Modules\VirtualClass\Entities\VirtualClass;
    use Modules\WaitList\Entities\CourseWaitingList;
    
    /**
     * @property int $id
     * @property string $name
     * @property int $user_id
     * @property bool $status
     * @property string|null $title
     * @property string|null $description
     * @property string|null $url
     * @property bool $show_home
     * @property int $position_order
     * @property string|null $image
     * @property string|null $thumbnail
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $parent_id
     * @property-read $full_path attribute
     * @property-read $quizzes_count attribute
     * @property-read $slug attribute
     * @property-read $course_count attribute
     * @property-read mixed[] $translations attribute
     * @property _IH_Category_C|Category[] $activeSubcategories
     * @property-read int $active_subcategories_count
     * @method HasMany|_IH_Category_QB activeSubcategories()
     * @property _IH_OrgPolicyCategory_C|OrgPolicyCategory[] $assignCategoryInGroupPolicy
     * @property-read int $assign_category_in_group_policy_count
     * @method HasMany|_IH_OrgPolicyCategory_QB assignCategoryInGroupPolicy()
     * @property _IH_InstructorTeachingCategory_C|InstructorTeachingCategory[] $categoryInstructor
     * @property-read int $category_instructor_count
     * @method HasMany|_IH_InstructorTeachingCategory_QB categoryInstructor()
     * @property _IH_Category_C|Category[] $childs
     * @property-read int $childs_count
     * @method HasMany|_IH_Category_QB childs()
     * @property _IH_Course_C|Course[] $courses
     * @property-read int $courses_count
     * @method HasMany|_IH_Course_QB courses()
     * @property _IH_Course_C|Course[] $getcourseCountAttribute
     * @property-read int $getcourse_count_attribute_count
     * @method HasMany|_IH_Course_QB getcourseCountAttribute()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property Category|null $parent
     * @method BelongsTo|_IH_Category_QB parent()
     * @property _IH_OnlineQuiz_C|OnlineQuiz[] $quizzesCategoryCount
     * @property-read int $quizzes_category_count_count
     * @method HasMany|_IH_OnlineQuiz_QB quizzesCategoryCount()
     * @property _IH_OnlineQuiz_C|OnlineQuiz[] $quizzesSubCategoryCount
     * @property-read int $quizzes_sub_category_count_count
     * @method HasMany|_IH_OnlineQuiz_QB quizzesSubCategoryCount()
     * @property _IH_Category_C|Category[] $subcategories
     * @property-read int $subcategories_count
     * @method HasMany|_IH_Category_QB subcategories()
     * @property _IH_Course_C|Course[] $totalCourses
     * @property-read int $total_courses_count
     * @method HasMany|_IH_Course_QB totalCourses()
     * @property _IH_Course_C|Course[] $totalEnrolled
     * @property-read int $total_enrolled_count
     * @method HasManyThrough|_IH_Course_QB totalEnrolled()
     * @method static _IH_Category_QB onWriteConnection()
     * @method _IH_Category_QB newQuery()
     * @method static _IH_Category_QB on(null|string $connection = null)
     * @method static _IH_Category_QB query()
     * @method static _IH_Category_QB with(array|string $relations)
     * @method _IH_Category_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Category_C|Category[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_Category_QB
     */
    class Category extends Model {}
    
    /**
     * @property int $id
     * @property int $course_id
     * @property string $name
     * @property int $chapter_no
     * @property bool $is_lock
     * @property Carbon|null $unlock_date
     * @property int|null $unlock_days
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $position
     * @property _IH_Lesson_C|Lesson[] $lessons
     * @property-read int $lessons_count
     * @method HasMany|_IH_Lesson_QB lessons()
     * @method static _IH_Chapter_QB onWriteConnection()
     * @method _IH_Chapter_QB newQuery()
     * @method static _IH_Chapter_QB on(null|string $connection = null)
     * @method static _IH_Chapter_QB query()
     * @method static _IH_Chapter_QB with(array|string $relations)
     * @method _IH_Chapter_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Chapter_C|Chapter[] all()
     * @ownLinks course_id,\Modules\CourseSetting\Entities\Course,id
     * @foreignLinks id,\Modules\CourseSetting\Entities\Lesson,chapter_id|id,\Modules\StudentSetting\Entities\BookmarkCourse,chapter_id|id,\App\LessonComplete,chapter_id
     * @mixin _IH_Chapter_QB
     */
    class Chapter extends Model {}
    
    /**
     * @property int $school_subject_id
     * @property-read null $assistant_instructors_ids attribute
     * @property-read float|int|mixed $discount_price attribute
     * @property-read $in_process attribute
     * @property-read bool $is_guest_user_cart attribute
     * @property-read bool $is_login_user_bookmark attribute
     * @property-read bool $is_login_user_cart attribute
     * @property-read bool $is_login_user_enrolled attribute
     * @property-read bool $is_login_user_review attribute
     * @property-read int $login_user_total_percentage attribute
     * @property-read $not_stated_yet attribute
     * @property-read array $star_wise_review attribute
     * @property-read $total_review attribute
     * @property-read $date_format attribute
     * @property-read $enroll_count attribute
     * @property-read $published_date attribute
     * @property-read $purchase_price attribute
     * @property-read $sum_rev attribute
     * @property-read mixed[] $translations attribute
     * @property _IH_User_C|User[] $BookmarkUsers
     * @property-read int $bookmark_users_count
     * @method BelongsToMany|_IH_User_QB BookmarkUsers()
     * @property _IH_CourseReveiw_C|CourseReveiw[] $activeReviews
     * @property-read int $active_reviews_count
     * @method HasMany|_IH_CourseReveiw_QB activeReviews()
     * @property _IH_LmsBadge_C|LmsBadge[] $badges
     * @property-read int $badges_count
     * @method MorphToMany|_IH_LmsBadge_QB badges()
     * @property _IH_User_C|User[] $cartUsers
     * @property-read int $cart_users_count
     * @method BelongsToMany|_IH_User_QB cartUsers()
     * @property Category $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property CertificateTemplate $certificate
     * @method BelongsTo|_IH_CertificateTemplate_QB certificate()
     * @property _IH_Chapter_C|Chapter[] $chapters
     * @property-read int $chapters_count
     * @method HasMany|_IH_Chapter_QB chapters()
     * @property VirtualClass $class
     * @method BelongsTo|_IH_VirtualClass_QB class()
     * @property _IH_CourseComment_C|CourseComment[] $comments
     * @property-read int $comments_count
     * @method HasMany|_IH_CourseComment_QB comments()
     * @property _IH_LessonComplete_C|LessonComplete[] $completeLessons
     * @property-read int $complete_lessons_count
     * @method HasMany|_IH_LessonComplete_QB completeLessons()
     * @property _IH_QuizTest_C|QuizTest[] $completeQuiz
     * @property-read int $complete_quiz_count
     * @method HasMany|_IH_QuizTest_QB completeQuiz()
     * @property CourseLevel $courseLevel
     * @method BelongsTo|_IH_CourseLevel_QB courseLevel()
     * @property _IH_InfixHomework_C|InfixHomework[] $courseStudyMaterials
     * @property-read int $course_study_materials_count
     * @method HasMany|_IH_InfixHomework_QB courseStudyMaterials()
     * @property _IH_User_C|User[] $enrollUsers
     * @property-read int $enroll_users_count
     * @method BelongsToMany|_IH_User_QB enrollUsers()
     * @property _IH_CourseEnrolled_C|CourseEnrolled[] $enrolls
     * @property-read int $enrolls_count
     * @method HasMany|_IH_CourseEnrolled_QB enrolls()
     * @property _IH_CourseExercise_C|CourseExercise[] $files
     * @property-read int $files_count
     * @method HasMany|_IH_CourseExercise_QB files()
     * @property _IH_Forum_C|Forum[] $forums
     * @property-read int $forums_count
     * @method HasMany|_IH_Forum_QB forums()
     * @property AssignStudent $hasEnrollForCPd
     * @method HasOne|_IH_AssignStudent_QB hasEnrollForCPd()
     * @property ClassCourseAssignStudent $hasEnrollForClass
     * @method HasOne|_IH_ClassCourseAssignStudent_QB hasEnrollForClass()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property Group $isGroupCourse
     * @method HasOne|_IH_Group_QB isGroupCourse()
     * @property Language $language
     * @method BelongsTo|_IH_Language_QB language()
     * @property _IH_Lesson_C|Lesson[] $lessonQuizzes
     * @property-read int $lesson_quizzes_count
     * @method HasMany|_IH_Lesson_QB lessonQuizzes()
     * @property _IH_Lesson_C|Lesson[] $lessons
     * @property-read int $lessons_count
     * @method HasMany|_IH_Lesson_QB lessons()
     * @property _IH_OrgAttendance_C|OrgAttendance[] $orgAttendance
     * @property-read int $org_attendance_count
     * @method HasMany|_IH_OrgAttendance_QB orgAttendance()
     * @property _IH_OrgSubscriptionCourseList_C|OrgSubscriptionCourseList[] $orgCourseList
     * @property-read int $org_course_list_count
     * @method HasMany|_IH_OrgSubscriptionCourseList_QB orgCourseList()
     * @property _IH_OrgSubscriptionCourseList_C|OrgSubscriptionCourseList[] $orgSubscriptionCourseList
     * @property-read int $org_subscription_course_list_count
     * @method HasMany|_IH_OrgSubscriptionCourseList_QB orgSubscriptionCourseList()
     * @property _IH_PricePlan_C|PricePlan[] $pricePlans
     * @property-read int $price_plans_count
     * @method MorphToMany|_IH_PricePlan_QB pricePlans()
     * @property Product $product
     * @method BelongsTo|_IH_Product_QB product()
     * @property ProductCategory $product_category
     * @method BelongsTo|_IH_ProductCategory_QB product_category()
     * @property OnlineQuiz $quiz
     * @method BelongsTo|_IH_OnlineQuiz_QB quiz()
     * @property _IH_QuizTest_C|QuizTest[] $quizCompletes
     * @property-read int $quiz_completes_count
     * @method HasMany|_IH_QuizTest_QB quizCompletes()
     * @property _IH_CourseReveiw_C|CourseReveiw[] $reviews
     * @property-read int $reviews_count
     * @method HasMany|_IH_CourseReveiw_QB reviews()
     * @property _IH_OnlineQuizTestShift_C|OnlineQuizTestShift[] $shifts
     * @property-read int $shifts_count
     * @method HasMany|_IH_OnlineQuizTestShift_QB shifts()
     * @property Category $subCategory
     * @method BelongsTo|_IH_Category_QB subCategory()
     * @property Survey $survey
     * @method HasOne|_IH_Survey_QB survey()
     * @property _IH_Forum_C|Forum[] $uniqueForums
     * @property-read int $unique_forums_count
     * @method HasMany|_IH_Forum_QB uniqueForums()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @property _IH_QuizTest_C|QuizTest[] $userCourseCompletePercentage
     * @property-read int $user_course_complete_percentage_count
     * @method HasMany|_IH_QuizTest_QB userCourseCompletePercentage()
     * @property VirtualClass $virtualClass
     * @method BelongsTo|_IH_VirtualClass_QB virtualClass()
     * @property _IH_CourseWaitingList_C|CourseWaitingList[] $waitList
     * @property-read int $wait_list_count
     * @method HasMany|_IH_CourseWaitingList_QB waitList()
     * @method static _IH_Course_QB onWriteConnection()
     * @method _IH_Course_QB newQuery()
     * @method static _IH_Course_QB on(null|string $connection = null)
     * @method static _IH_Course_QB query()
     * @method static _IH_Course_QB with(array|string $relations)
     * @method _IH_Course_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Course_C|Course[] all()
     * @foreignLinks id,\Modules\CourseSetting\Entities\CourseCanceled,course_id|id,\Modules\NotificationSetup\Entities\PostedNotification,course_id
     * @mixin _IH_Course_QB
     */
    class Course extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $course_id
     * @property float $purchase_price
     * @property bool $refund
     * @property int|null $cancel_by
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User|null $confirmUser
     * @method BelongsTo|_IH_User_QB confirmUser()
     * @property Course $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_CourseCanceled_QB onWriteConnection()
     * @method _IH_CourseCanceled_QB newQuery()
     * @method static _IH_CourseCanceled_QB on(null|string $connection = null)
     * @method static _IH_CourseCanceled_QB query()
     * @method static _IH_CourseCanceled_QB with(array|string $relations)
     * @method _IH_CourseCanceled_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CourseCanceled_C|CourseCanceled[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|course_id,\Modules\CourseSetting\Entities\Course,id
     * @mixin _IH_CourseCanceled_QB
     */
    class CourseCanceled extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $course_id
     * @property int $instructor_id
     * @property bool $status
     * @property string $comment
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $comment_date attribute
     * @property-read $submitted_date attribute
     * @property Course $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property _IH_CourseCommentReply_C|CourseCommentReply[] $replies
     * @property-read int $replies_count
     * @method HasMany|_IH_CourseCommentReply_QB replies()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_CourseComment_QB onWriteConnection()
     * @method _IH_CourseComment_QB newQuery()
     * @method static _IH_CourseComment_QB on(null|string $connection = null)
     * @method static _IH_CourseComment_QB query()
     * @method static _IH_CourseComment_QB with(array|string $relations)
     * @method _IH_CourseComment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CourseComment_C|CourseComment[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|course_id,\Modules\CourseSetting\Entities\Course,id
     * @foreignLinks id,\Illuminate\Notifications\DatabaseNotification,course_comment_id
     * @mixin _IH_CourseComment_QB
     */
    class CourseComment extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $course_id
     * @property int $comment_id
     * @property bool $status
     * @property string $reply
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $reply_id
     * @property-read $reply_date attribute
     * @property Course $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_CourseCommentReply_QB onWriteConnection()
     * @method _IH_CourseCommentReply_QB newQuery()
     * @method static _IH_CourseCommentReply_QB on(null|string $connection = null)
     * @method static _IH_CourseCommentReply_QB query()
     * @method static _IH_CourseCommentReply_QB with(array|string $relations)
     * @method _IH_CourseCommentReply_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CourseCommentReply_C|CourseCommentReply[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|course_id,\Modules\CourseSetting\Entities\Course,id
     * @mixin _IH_CourseCommentReply_QB
     */
    class CourseCommentReply extends Model {}
    
    /**
     * @property int $id
     * @property string|null $tracking
     * @property int $user_id
     * @property int $course_id
     * @property float|null $purchase_price
     * @property string|null $coupon
     * @property float|null $discount_amount
     * @property bool $status
     * @property float|null $reveune
     * @property string|null $reason
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string $subscription
     * @property Carbon|null $subscription_validity_date
     * @property int $bundle_course_id
     * @property Carbon|null $bundle_course_validity
     * @property string|null $enrolled_via
     * @property int|null $pathway_id
     * @property int|null $enrolled_by
     * @property Carbon|null $last_view_at
     * @property string|null $subscription_validity_time
     * @property int $org_subscription_plan_id
     * @property int|null $shift
     * @property int|null $installment_purchase_id
     * @property int $send_expire_notification
     * @property int $qty
     * @property bool $is_store
     * @property-read $user_complete_date attribute
     * @property-read int $user_total_percentage attribute
     * @property-read $enrolled_date attribute
     * @property BillingDetails $bill
     * @method BelongsTo|_IH_BillingDetails_QB bill()
     * @property BillingDetails $billDetails
     * @method BelongsTo|_IH_BillingDetails_QB billDetails()
     * @property Checkout|null $checkout
     * @method BelongsTo|_IH_Checkout_QB checkout()
     * @property _IH_LessonComplete_C|LessonComplete[] $completeLessons
     * @property-read int $complete_lessons_count
     * @method HasMany|_IH_LessonComplete_QB completeLessons()
     * @property Course $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property User|null $enrolledBy
     * @method BelongsTo|_IH_User_QB enrolledBy()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property OrgCourseSubscription $orgSubscriptionPlan
     * @method BelongsTo|_IH_OrgCourseSubscription_QB orgSubscriptionPlan()
     * @property Pathway|null $pathway
     * @method BelongsTo|_IH_Pathway_QB pathway()
     * @property _IH_QuizTest_C|QuizTest[] $quizCompletes
     * @property-read int $quiz_completes_count
     * @method HasMany|_IH_QuizTest_QB quizCompletes()
     * @property _IH_OnlineQuizTestShift_C|OnlineQuizTestShift[] $shiftDetails
     * @property-read int $shift_details_count
     * @method HasMany|_IH_OnlineQuizTestShift_QB shiftDetails()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_CourseEnrolled_QB onWriteConnection()
     * @method _IH_CourseEnrolled_QB newQuery()
     * @method static _IH_CourseEnrolled_QB on(null|string $connection = null)
     * @method static _IH_CourseEnrolled_QB query()
     * @method static _IH_CourseEnrolled_QB with(array|string $relations)
     * @method _IH_CourseEnrolled_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CourseEnrolled_C|CourseEnrolled[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|course_id,\Modules\CourseSetting\Entities\Course,id|bundle_course_id,\Modules\BundleSubscription\Entities\BundleCourse,id|pathway_id,\Modules\SkillAndPathway\Entities\Pathway,id
     * @foreignLinks id,\Illuminate\Notifications\DatabaseNotification,course_enrolled_id
     * @mixin _IH_CourseEnrolled_QB
     */
    class CourseEnrolled extends Model {}
    
    /**
     * @property int $id
     * @property int $course_id
     * @property string $fileName
     * @property string $file
     * @property bool $lock
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property float|null $old_file_size
     * @property float|null $file_size
     * @method static _IH_CourseExercise_QB onWriteConnection()
     * @method _IH_CourseExercise_QB newQuery()
     * @method static _IH_CourseExercise_QB on(null|string $connection = null)
     * @method static _IH_CourseExercise_QB query()
     * @method static _IH_CourseExercise_QB with(array|string $relations)
     * @method _IH_CourseExercise_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CourseExercise_C|CourseExercise[] all()
     * @ownLinks course_id,\Modules\CourseSetting\Entities\Course,id
     * @mixin _IH_CourseExercise_QB
     */
    class CourseExercise extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $text_color
     * @property string|null $background_color
     * @property int|null $organization_id
     * @property-read mixed[] $translations attribute
     * @property _IH_Course_C|Course[] $courses
     * @property-read int $courses_count
     * @method HasMany|_IH_Course_QB courses()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property _IH_Course_C|Course[] $totalCourse
     * @property-read int $total_course_count
     * @method HasMany|_IH_Course_QB totalCourse()
     * @method static _IH_CourseLevel_QB onWriteConnection()
     * @method _IH_CourseLevel_QB newQuery()
     * @method static _IH_CourseLevel_QB on(null|string $connection = null)
     * @method static _IH_CourseLevel_QB query()
     * @method static _IH_CourseLevel_QB with(array|string $relations)
     * @method _IH_CourseLevel_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CourseLevel_C|CourseLevel[] all()
     * @mixin _IH_CourseLevel_QB
     */
    class CourseLevel extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $course_id
     * @property bool $status
     * @property string $comment
     * @property float $star
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $instructor_id
     * @property Course $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_CourseReveiw_QB onWriteConnection()
     * @method _IH_CourseReveiw_QB newQuery()
     * @method static _IH_CourseReveiw_QB on(null|string $connection = null)
     * @method static _IH_CourseReveiw_QB query()
     * @method static _IH_CourseReveiw_QB with(array|string $relations)
     * @method _IH_CourseReveiw_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CourseReveiw_C|CourseReveiw[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|course_id,\Modules\CourseSetting\Entities\Course,id
     * @mixin _IH_CourseReveiw_QB
     */
    class CourseReveiw extends Model {}
    
    /**
     * @property int $id
     * @property int $course_id
     * @property int $chapter_id
     * @property int|null $quiz_id
     * @property string|null $name
     * @property string|null $description
     * @property string|null $video_url
     * @property string|null $host
     * @property string|null $duration
     * @property bool $is_lock
     * @property bool $is_quiz
     * @property Carbon|null $unlock_date
     * @property int|null $unlock_days
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $position
     * @property int|null $is_assignment
     * @property int|null $assignment_id
     * @property float|null $old_file_size
     * @property float|null $file_size
     * @property string|null $scorm_title
     * @property string|null $scorm_version
     * @property string|null $scorm_identifier
     * @property int|null $file_id
     * @property int|null $org_material_id
     * @property int|null $h5p_id
     * @property _IH_InfixAssignment_C|InfixAssignment[] $assignment
     * @property-read int $assignment_count
     * @method HasMany|_IH_InfixAssignment_QB assignment()
     * @property InfixAssignment|null $assignmentInfo
     * @method HasOne|_IH_InfixAssignment_QB assignmentInfo()
     * @property BunnyLesson $bunnyLesson
     * @method HasOne|_IH_BunnyLesson_QB bunnyLesson()
     * @property Chapter $chapter
     * @method BelongsTo|_IH_Chapter_QB chapter()
     * @property LessonComplete $completed
     * @method HasOne|_IH_LessonComplete_QB completed()
     * @property Course $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property _IH_LessonFile_C|LessonFile[] $files
     * @property-read int $files_count
     * @method HasMany|_IH_LessonFile_QB files()
     * @property H5pContent|null $h5pContent
     * @method BelongsTo|_IH_H5pContent_QB h5pContent()
     * @property H5pReport $h5pReport
     * @method HasOne|_IH_H5pReport_QB h5pReport()
     * @property OnlineQuiz|null $lessonQuiz
     * @method BelongsTo|_IH_OnlineQuiz_QB lessonQuiz()
     * @property OrgMaterial|null $orgMaterial
     * @method BelongsTo|_IH_OrgMaterial_QB orgMaterial()
     * @property _IH_OnlineQuiz_C|OnlineQuiz[] $quiz
     * @property-read int $quiz_count
     * @method HasMany|_IH_OnlineQuiz_QB quiz()
     * @method static _IH_Lesson_QB onWriteConnection()
     * @method _IH_Lesson_QB newQuery()
     * @method static _IH_Lesson_QB on(null|string $connection = null)
     * @method static _IH_Lesson_QB query()
     * @method static _IH_Lesson_QB with(array|string $relations)
     * @method _IH_Lesson_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Lesson_C|Lesson[] all()
     * @ownLinks course_id,\Modules\CourseSetting\Entities\Course,id|chapter_id,\Modules\CourseSetting\Entities\Chapter,id|org_material_id,\Modules\Org\Entities\OrgMaterial,id
     * @foreignLinks id,\Modules\StudentSetting\Entities\BookmarkCourse,lesson_id|id,\App\LessonComplete,lesson_id|id,\Modules\Homework\Entities\InfixHomework,lesson_id|id,\Modules\Forum\Entities\Forum,lesson_id|id,\Modules\SCORM\Entities\ScormReport,lesson_id|id,\Modules\XAPI\Entities\XapiReport,lesson_id|id,\Modules\CourseSetting\Entities\LessonFile,lesson_id|id,\Modules\H5P\Entities\H5pReport,lesson_id|id,\Modules\BunnyStorage\Entities\BunnyLesson,lesson_id
     * @mixin _IH_Lesson_QB
     */
    class Lesson extends Model {}
    
    /**
     * @property int $id
     * @property int $lesson_id
     * @property string|null $link
     * @property float|null $version
     * @property int|null $updated_by
     * @property int|null $size
     * @property string|null $type
     * @property string|null $scorm_title
     * @property string|null $scorm_version
     * @property string|null $scorm_identifier
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $title
     * @property Lesson $lesson
     * @method BelongsTo|_IH_Lesson_QB lesson()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_LessonFile_QB onWriteConnection()
     * @method _IH_LessonFile_QB newQuery()
     * @method static _IH_LessonFile_QB on(null|string $connection = null)
     * @method static _IH_LessonFile_QB query()
     * @method static _IH_LessonFile_QB with(array|string $relations)
     * @method _IH_LessonFile_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_LessonFile_C|LessonFile[] all()
     * @ownLinks lesson_id,\Modules\CourseSetting\Entities\Lesson,id
     * @mixin _IH_LessonFile_QB
     */
    class LessonFile extends Model {}
    
    /**
     * @property string $id
     * @property string|null $type
     * @property int $notifiable_id
     * @property string $notifiable_type
     * @property string|null $data
     * @property Carbon|null $read_at
     * @property int|null $course_id
     * @property int|null $user_id
     * @property int|null $author_id
     * @property int|null $message_id
     * @property int|null $course_comment_id
     * @property int|null $course_review_id
     * @property int|null $course_enrolled_id
     * @property bool|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $notification_date attribute
     * @property CourseComment $comment
     * @method BelongsTo|_IH_CourseComment_QB comment()
     * @property Course|null $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property CourseEnrolled $enroll
     * @method BelongsTo|_IH_CourseEnrolled_QB enroll()
     * @property User $instructor
     * @method BelongsTo|_IH_User_QB instructor()
     * @property Message|null $message
     * @method BelongsTo|_IH_Message_QB message()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Notification_QB onWriteConnection()
     * @method _IH_Notification_QB newQuery()
     * @method static _IH_Notification_QB on(null|string $connection = null)
     * @method static _IH_Notification_QB query()
     * @method static _IH_Notification_QB with(array|string $relations)
     * @method _IH_Notification_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Notification_C|Notification[] all()
     * @ownLinks course_id,\Modules\CourseSetting\Entities\Course,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|message_id,\Modules\SystemSetting\Entities\Message,id|course_comment_id,\Modules\CourseSetting\Entities\CourseComment,id|course_enrolled_id,\Modules\CourseSetting\Entities\CourseEnrolled,id
     * @foreignLinks id,\Modules\NotificationSetup\Entities\PostedNotificationReceiver,notification_id
     * @mixin _IH_Notification_QB
     */
    class Notification extends Model {}
    
    /**
     * @method static _IH_Package_QB onWriteConnection()
     * @method _IH_Package_QB newQuery()
     * @method static _IH_Package_QB on(null|string $connection = null)
     * @method static _IH_Package_QB query()
     * @method static _IH_Package_QB with(array|string $relations)
     * @method _IH_Package_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Package_C|Package[] all()
     * @mixin _IH_Package_QB
     */
    class Package extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property bool $status
     * @property int $order
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_SchoolSubject_QB onWriteConnection()
     * @method _IH_SchoolSubject_QB newQuery()
     * @method static _IH_SchoolSubject_QB on(null|string $connection = null)
     * @method static _IH_SchoolSubject_QB query()
     * @method static _IH_SchoolSubject_QB with(array|string $relations)
     * @method _IH_SchoolSubject_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SchoolSubject_C|SchoolSubject[] all()
     * @foreignLinks id,\Modules\CourseSetting\Entities\Course,school_subject_id
     * @mixin _IH_SchoolSubject_QB
     */
    class SchoolSubject extends Model {}
    
    /**
     * @property int $id
     * @property int|null $category_id
     * @property string|null $name
     * @property string|null $image
     * @property bool|null $status
     * @property bool|null $show_home
     * @property int|null $position_order
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $slug attribute
     * @property Category|null $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property _IH_Course_C|Course[] $courses
     * @property-read int $courses_count
     * @method HasMany|_IH_Course_QB courses()
     * @method static _IH_SubCategory_QB onWriteConnection()
     * @method _IH_SubCategory_QB newQuery()
     * @method static _IH_SubCategory_QB on(null|string $connection = null)
     * @method static _IH_SubCategory_QB query()
     * @method static _IH_SubCategory_QB with(array|string $relations)
     * @method _IH_SubCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SubCategory_C|SubCategory[] all()
     * @ownLinks category_id,\Modules\CourseSetting\Entities\Category,id
     * @foreignLinks id,\Modules\Quiz\Entities\OnlineQuiz,sub_category_id|id,\Modules\Quiz\Entities\QuestionBank,sub_category_id|id,\Modules\VirtualClass\Entities\VirtualClass,sub_category_id|id,\Modules\Appointment\Entities\InstructorTeachingCategory,sub_category_id|id,\Modules\Appointment\Entities\Schedule,sub_category_id|id,\Modules\Survey\Entities\SurveyQuestionBank,sub_category_id|id,\Modules\Store\Entities\Product,sub_category_id
     * @mixin _IH_SubCategory_QB
     */
    class SubCategory extends Model {}
}