<?php //5feba8599d7d0884fdf22652965689c9
/** @noinspection all */

namespace Modules\MyClass\Entities {

    use App\LessonComplete;
    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\_IH_LessonComplete_C;
    use LaravelIdea\Helper\App\_IH_LessonComplete_QB;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use LaravelIdea\Helper\Modules\MyClass\Entities\_IH_ClassAttendance_C;
    use LaravelIdea\Helper\Modules\MyClass\Entities\_IH_ClassAttendance_QB;
    use LaravelIdea\Helper\Modules\MyClass\Entities\_IH_ClassCourseAssignStudent_C;
    use LaravelIdea\Helper\Modules\MyClass\Entities\_IH_ClassCourseAssignStudent_QB;
    use LaravelIdea\Helper\Modules\MyClass\Entities\_IH_ClassCourse_C;
    use LaravelIdea\Helper\Modules\MyClass\Entities\_IH_ClassCourse_QB;
    use LaravelIdea\Helper\Modules\MyClass\Entities\_IH_LmsClass_C;
    use LaravelIdea\Helper\Modules\MyClass\Entities\_IH_LmsClass_QB;
    use Modules\CourseSetting\Entities\Course;
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string|null $token
     * @property Carbon $login_at
     * @property Carbon|null $logout_at
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_ClassAttendance_QB onWriteConnection()
     * @method _IH_ClassAttendance_QB newQuery()
     * @method static _IH_ClassAttendance_QB on(null|string $connection = null)
     * @method static _IH_ClassAttendance_QB query()
     * @method static _IH_ClassAttendance_QB with(array|string $relations)
     * @method _IH_ClassAttendance_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ClassAttendance_C|ClassAttendance[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_ClassAttendance_QB
     */
    class ClassAttendance extends Model {}
    
    /**
     * @property int $id
     * @property int|null $course_id
     * @property int|null $class_id
     * @property int|null $created_by
     * @property int|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_LessonComplete_C|LessonComplete[] $completeCoursePercentage
     * @property-read int $complete_course_percentage_count
     * @method HasMany|_IH_LessonComplete_QB completeCoursePercentage()
     * @property Course|null $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property User|null $userInfo
     * @method BelongsTo|_IH_User_QB userInfo()
     * @method static _IH_ClassCourse_QB onWriteConnection()
     * @method _IH_ClassCourse_QB newQuery()
     * @method static _IH_ClassCourse_QB on(null|string $connection = null)
     * @method static _IH_ClassCourse_QB query()
     * @method static _IH_ClassCourse_QB with(array|string $relations)
     * @method _IH_ClassCourse_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ClassCourse_C|ClassCourse[] all()
     * @ownLinks course_id,\Modules\CourseSetting\Entities\Course,id
     * @foreignLinks id,\Modules\Payment\Entities\InstructorPayout,class_course_id|id,\Modules\MyClass\Entities\ClassCourseAssignStudent,class_course_id
     * @mixin _IH_ClassCourse_QB
     */
    class ClassCourse extends Model {}
    
    /**
     * @property int $id
     * @property int|null $course_id
     * @property int|null $class_id
     * @property int|null $created_by
     * @property int|null $class_course_id
     * @property int|null $student_id
     * @property int|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User|null $addedBy
     * @method BelongsTo|_IH_User_QB addedBy()
     * @property LmsClass|null $class
     * @method BelongsTo|_IH_LmsClass_QB class()
     * @property Course|null $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property User|null $student
     * @method BelongsTo|_IH_User_QB student()
     * @method static _IH_ClassCourseAssignStudent_QB onWriteConnection()
     * @method _IH_ClassCourseAssignStudent_QB newQuery()
     * @method static _IH_ClassCourseAssignStudent_QB on(null|string $connection = null)
     * @method static _IH_ClassCourseAssignStudent_QB query()
     * @method static _IH_ClassCourseAssignStudent_QB with(array|string $relations)
     * @method _IH_ClassCourseAssignStudent_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ClassCourseAssignStudent_C|ClassCourseAssignStudent[] all()
     * @ownLinks course_id,\Modules\CourseSetting\Entities\Course,id|class_course_id,\Modules\MyClass\Entities\ClassCourse,id
     * @mixin _IH_ClassCourseAssignStudent_QB
     */
    class ClassCourseAssignStudent extends Model {}
    
    /**
     * @property int $id
     * @property string|null $name
     * @property int|null $created_by
     * @property int|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_ClassCourseAssignStudent_C|ClassCourseAssignStudent[] $assignClasses
     * @property-read int $assign_classes_count
     * @method HasMany|_IH_ClassCourseAssignStudent_QB assignClasses()
     * @property _IH_ClassCourse_C|ClassCourse[] $classes
     * @property-read int $classes_count
     * @method HasMany|_IH_ClassCourse_QB classes()
     * @property _IH_ClassCourse_C|ClassCourse[] $courses
     * @property-read int $courses_count
     * @method HasMany|_IH_ClassCourse_QB courses()
     * @property _IH_ClassCourseAssignStudent_C|ClassCourseAssignStudent[] $students
     * @property-read int $students_count
     * @method HasMany|_IH_ClassCourseAssignStudent_QB students()
     * @property User|null $userInfo
     * @method BelongsTo|_IH_User_QB userInfo()
     * @method static _IH_LmsClass_QB onWriteConnection()
     * @method _IH_LmsClass_QB newQuery()
     * @method static _IH_LmsClass_QB on(null|string $connection = null)
     * @method static _IH_LmsClass_QB query()
     * @method static _IH_LmsClass_QB with(array|string $relations)
     * @method _IH_LmsClass_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_LmsClass_C|LmsClass[] all()
     * @mixin _IH_LmsClass_QB
     */
    class LmsClass extends Model {}
}