<?php //7699c105ae9c96f1264b96d54ee16e21
/** @noinspection all */

namespace Modules\WhatsappSupport\Entities {

    use App\Models\LmsInstitute;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\Modules\WhatsappSupport\Entities\_IH_Agents_C;
    use LaravelIdea\Helper\Modules\WhatsappSupport\Entities\_IH_Agents_QB;
    use LaravelIdea\Helper\Modules\WhatsappSupport\Entities\_IH_AgentTime_C;
    use LaravelIdea\Helper\Modules\WhatsappSupport\Entities\_IH_AgentTime_QB;
    use LaravelIdea\Helper\Modules\WhatsappSupport\Entities\_IH_Message_C;
    use LaravelIdea\Helper\Modules\WhatsappSupport\Entities\_IH_Message_QB;
    use LaravelIdea\Helper\Modules\WhatsappSupport\Entities\_IH_Settings_C;
    use LaravelIdea\Helper\Modules\WhatsappSupport\Entities\_IH_Settings_QB;
    
    /**
     * @property int $id
     * @property int $agent_id
     * @property string $day
     * @property Carbon $start
     * @property Carbon $end
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $end_time_str attribute
     * @property-read $start_time_str attribute
     * @property Agents $agent
     * @method BelongsTo|_IH_Agents_QB agent()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_AgentTime_QB onWriteConnection()
     * @method _IH_AgentTime_QB newQuery()
     * @method static _IH_AgentTime_QB on(null|string $connection = null)
     * @method static _IH_AgentTime_QB query()
     * @method static _IH_AgentTime_QB with(array|string $relations)
     * @method _IH_AgentTime_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AgentTime_C|AgentTime[] all()
     * @ownLinks agent_id,\Modules\WhatsappSupport\Entities\Agents,id
     * @mixin _IH_AgentTime_QB
     */
    class AgentTime extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $designation
     * @property string|null $avatar
     * @property string $number
     * @property bool $status
     * @property bool $always_available
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property _IH_AgentTime_C|AgentTime[] $times
     * @property-read int $times_count
     * @method HasMany|_IH_AgentTime_QB times()
     * @method static _IH_Agents_QB onWriteConnection()
     * @method _IH_Agents_QB newQuery()
     * @method static _IH_Agents_QB on(null|string $connection = null)
     * @method static _IH_Agents_QB query()
     * @method static _IH_Agents_QB with(array|string $relations)
     * @method _IH_Agents_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Agents_C|Agents[] all()
     * @foreignLinks id,\Modules\WhatsappSupport\Entities\AgentTime,agent_id
     * @mixin _IH_Agents_QB
     */
    class Agents extends Model {}
    
    /**
     * @property int $id
     * @property string|null $message
     * @property string|null $ip
     * @property string|null $number
     * @property string|null $device_type
     * @property string|null $os
     * @property string|null $browser
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_Message_QB onWriteConnection()
     * @method _IH_Message_QB newQuery()
     * @method static _IH_Message_QB on(null|string $connection = null)
     * @method static _IH_Message_QB query()
     * @method static _IH_Message_QB with(array|string $relations)
     * @method _IH_Message_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Message_C|Message[] all()
     * @mixin _IH_Message_QB
     */
    class Message extends Model {}
    
    /**
     * @property int $id
     * @property string $agent_type
     * @property string $availability
     * @property string $showing_page
     * @property string $color
     * @property string|null $intro_text
     * @property string|null $welcome_message
     * @property string $homepage_url
     * @property string $primary_number
     * @property bool $open_popup
     * @property bool $disable_for_admin_panel
     * @property bool $show_unavailable_agent
     * @property int $layout
     * @property string|null $bubble_logo
     * @property string $layout_preview_url
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_Settings_QB onWriteConnection()
     * @method _IH_Settings_QB newQuery()
     * @method static _IH_Settings_QB on(null|string $connection = null)
     * @method static _IH_Settings_QB query()
     * @method static _IH_Settings_QB with(array|string $relations)
     * @method _IH_Settings_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Settings_C|Settings[] all()
     * @mixin _IH_Settings_QB
     */
    class Settings extends Model {}
}