<?php //55b25244bfab864765244ed00cdf634f
/** @noinspection all */

namespace Modules\SupportTicket\Entities {

    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\MorphTo;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\SupportTicket\Entities\_IH_SupportTicketFile_C;
    use LaravelIdea\Helper\Modules\SupportTicket\Entities\_IH_SupportTicketFile_QB;
    use LaravelIdea\Helper\Modules\SupportTicket\Entities\_IH_SupportTicket_C;
    use LaravelIdea\Helper\Modules\SupportTicket\Entities\_IH_SupportTicket_QB;
    use LaravelIdea\Helper\Modules\SupportTicket\Entities\_IH_TicketCategory_C;
    use LaravelIdea\Helper\Modules\SupportTicket\Entities\_IH_TicketCategory_QB;
    use LaravelIdea\Helper\Modules\SupportTicket\Entities\_IH_TicketMessageFile_C;
    use LaravelIdea\Helper\Modules\SupportTicket\Entities\_IH_TicketMessageFile_QB;
    use LaravelIdea\Helper\Modules\SupportTicket\Entities\_IH_TicketMessage_C;
    use LaravelIdea\Helper\Modules\SupportTicket\Entities\_IH_TicketMessage_QB;
    use LaravelIdea\Helper\Modules\SupportTicket\Entities\_IH_TicketPriority_C;
    use LaravelIdea\Helper\Modules\SupportTicket\Entities\_IH_TicketPriority_QB;
    use LaravelIdea\Helper\Modules\SupportTicket\Entities\_IH_TicketStatus_C;
    use LaravelIdea\Helper\Modules\SupportTicket\Entities\_IH_TicketStatus_QB;
    
    /**
     * @property int $id
     * @property string $reference_no
     * @property string $subject
     * @property string $description
     * @property int|null $category_id
     * @property int|null $priority_id
     * @property int|null $user_id
     * @property int|null $refer_id
     * @property int $status_id
     * @property int $seen
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $course_id
     * @property User|null $assignUser
     * @method BelongsTo|_IH_User_QB assignUser()
     * @property _IH_SupportTicketFile_C|SupportTicketFile[] $attachFiles
     * @property-read int $attach_files_count
     * @method MorphToMany|_IH_SupportTicketFile_QB attachFiles()
     * @property _IH_TicketMessageFile_C|TicketMessageFile[] $attachments
     * @property-read int $attachments_count
     * @method HasMany|_IH_TicketMessageFile_QB attachments()
     * @property TicketCategory|null $category
     * @method BelongsTo|_IH_TicketCategory_QB category()
     * @property _IH_TicketMessage_C|TicketMessage[] $messages
     * @property-read int $messages_count
     * @method HasMany|_IH_TicketMessage_QB messages()
     * @property TicketPriority|null $priority
     * @method BelongsTo|_IH_TicketPriority_QB priority()
     * @property TicketStatus $status
     * @method BelongsTo|_IH_TicketStatus_QB status()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_SupportTicket_QB onWriteConnection()
     * @method _IH_SupportTicket_QB newQuery()
     * @method static _IH_SupportTicket_QB on(null|string $connection = null)
     * @method static _IH_SupportTicket_QB query()
     * @method static _IH_SupportTicket_QB with(array|string $relations)
     * @method _IH_SupportTicket_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SupportTicket_C|SupportTicket[] all()
     * @ownLinks category_id,\Modules\CourseSetting\Entities\Category,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|course_id,\Modules\CourseSetting\Entities\Course,id
     * @mixin _IH_SupportTicket_QB
     */
    class SupportTicket extends Model {}
    
    /**
     * @property int $id
     * @property int $attachment_id
     * @property string $attachment_type
     * @property string|null $name
     * @property string|null $url
     * @property string|null $type
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Model $attachment
     * @method MorphTo attachment()
     * @method static _IH_SupportTicketFile_QB onWriteConnection()
     * @method _IH_SupportTicketFile_QB newQuery()
     * @method static _IH_SupportTicketFile_QB on(null|string $connection = null)
     * @method static _IH_SupportTicketFile_QB query()
     * @method static _IH_SupportTicketFile_QB with(array|string $relations)
     * @method _IH_SupportTicketFile_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SupportTicketFile_C|SupportTicketFile[] all()
     * @mixin _IH_SupportTicketFile_QB
     */
    class SupportTicketFile extends Model {}
    
    /**
     * @property int $id
     * @property string|null $name
     * @property bool $status
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property bool $is_system
     * @property string|null $slug
     * @method static _IH_TicketCategory_QB onWriteConnection()
     * @method _IH_TicketCategory_QB newQuery()
     * @method static _IH_TicketCategory_QB on(null|string $connection = null)
     * @method static _IH_TicketCategory_QB query()
     * @method static _IH_TicketCategory_QB with(array|string $relations)
     * @method _IH_TicketCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TicketCategory_C|TicketCategory[] all()
     * @mixin _IH_TicketCategory_QB
     */
    class TicketCategory extends Model {}
    
    /**
     * @property int $id
     * @property int|null $ticket_id
     * @property string $text
     * @property int $user_id
     * @property bool $type
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_SupportTicketFile_C|SupportTicketFile[] $attachFiles
     * @property-read int $attach_files_count
     * @method MorphToMany|_IH_SupportTicketFile_QB attachFiles()
     * @property _IH_TicketMessageFile_C|TicketMessageFile[] $attachMsgFile
     * @property-read int $attach_msg_file_count
     * @method HasMany|_IH_TicketMessageFile_QB attachMsgFile()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_TicketMessage_QB onWriteConnection()
     * @method _IH_TicketMessage_QB newQuery()
     * @method static _IH_TicketMessage_QB on(null|string $connection = null)
     * @method static _IH_TicketMessage_QB query()
     * @method static _IH_TicketMessage_QB with(array|string $relations)
     * @method _IH_TicketMessage_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TicketMessage_C|TicketMessage[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_TicketMessage_QB
     */
    class TicketMessage extends Model {}
    
    /**
     * @property int $id
     * @property int|null $message_id
     * @property string|null $url
     * @property string|null $name
     * @property string|null $type
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_TicketMessageFile_QB onWriteConnection()
     * @method _IH_TicketMessageFile_QB newQuery()
     * @method static _IH_TicketMessageFile_QB on(null|string $connection = null)
     * @method static _IH_TicketMessageFile_QB query()
     * @method static _IH_TicketMessageFile_QB with(array|string $relations)
     * @method _IH_TicketMessageFile_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TicketMessageFile_C|TicketMessageFile[] all()
     * @ownLinks message_id,\Modules\SystemSetting\Entities\Message,id
     * @mixin _IH_TicketMessageFile_QB
     */
    class TicketMessageFile extends Model {}
    
    /**
     * @property int $id
     * @property string|null $name
     * @property bool $status
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_TicketPriority_QB onWriteConnection()
     * @method _IH_TicketPriority_QB newQuery()
     * @method static _IH_TicketPriority_QB on(null|string $connection = null)
     * @method static _IH_TicketPriority_QB query()
     * @method static _IH_TicketPriority_QB with(array|string $relations)
     * @method _IH_TicketPriority_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TicketPriority_C|TicketPriority[] all()
     * @mixin _IH_TicketPriority_QB
     */
    class TicketPriority extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_TicketStatus_QB onWriteConnection()
     * @method _IH_TicketStatus_QB newQuery()
     * @method static _IH_TicketStatus_QB on(null|string $connection = null)
     * @method static _IH_TicketStatus_QB query()
     * @method static _IH_TicketStatus_QB with(array|string $relations)
     * @method _IH_TicketStatus_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TicketStatus_C|TicketStatus[] all()
     * @mixin _IH_TicketStatus_QB
     */
    class TicketStatus extends Model {}
}