<?php //e035df8dbd06172ec9b110e83183cdf9
/** @noinspection all */

namespace Modules\CPD\Entities {

    use App\Models\User as ModelsUser;
    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_User_QB as Models_IH_User_QB;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\Certificate\Entities\_IH_CertificateRecord_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use LaravelIdea\Helper\Modules\CPD\Entities\_IH_AssignCpdCourse_C;
    use LaravelIdea\Helper\Modules\CPD\Entities\_IH_AssignCpdCourse_QB;
    use LaravelIdea\Helper\Modules\CPD\Entities\_IH_AssignStudent_C;
    use LaravelIdea\Helper\Modules\CPD\Entities\_IH_AssignStudent_QB;
    use LaravelIdea\Helper\Modules\CPD\Entities\_IH_CpdSettings_C;
    use LaravelIdea\Helper\Modules\CPD\Entities\_IH_CpdSettings_QB;
    use LaravelIdea\Helper\Modules\CPD\Entities\_IH_Cpd_C;
    use LaravelIdea\Helper\Modules\CPD\Entities\_IH_Cpd_QB;
    use Modules\Certificate\Entities\CertificateRecord;
    use Modules\CourseSetting\Entities\Course;
    
    /**
     * @property int $id
     * @property int $cpd_id
     * @property int|null $course_id
     * @property int|null $added_by
     * @property int|null $student_id
     * @property int|null $total_student
     * @property int|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $end_date attribute
     * @property Course|null $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property Cpd $cpd
     * @method BelongsTo|_IH_Cpd_QB cpd()
     * @property Course|null $quiz
     * @method BelongsTo|_IH_Course_QB quiz()
     * @property _IH_AssignStudent_C|AssignStudent[] $studentEnrollCpdQuiz
     * @property-read int $student_enroll_cpd_quiz_count
     * @method HasMany|_IH_AssignStudent_QB studentEnrollCpdQuiz()
     * @property _IH_AssignStudent_C|AssignStudent[] $students
     * @property-read int $students_count
     * @method HasMany|_IH_AssignStudent_QB students()
     * @property User|null $userInfo
     * @method BelongsTo|_IH_User_QB userInfo()
     * @method static _IH_AssignCpdCourse_QB onWriteConnection()
     * @method _IH_AssignCpdCourse_QB newQuery()
     * @method static _IH_AssignCpdCourse_QB on(null|string $connection = null)
     * @method static _IH_AssignCpdCourse_QB query()
     * @method static _IH_AssignCpdCourse_QB with(array|string $relations)
     * @method _IH_AssignCpdCourse_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AssignCpdCourse_C|AssignCpdCourse[] all()
     * @ownLinks cpd_id,\Modules\CPD\Entities\Cpd,id|course_id,\Modules\CourseSetting\Entities\Course,id
     * @foreignLinks id,\Modules\Payment\Entities\InstructorPayout,assign_cpd_course_id
     * @mixin _IH_AssignCpdCourse_QB
     */
    class AssignCpdCourse extends Model {}
    
    /**
     * @property int $id
     * @property int|null $cpd_id
     * @property int|null $course_id
     * @property int|null $added_by
     * @property int|null $student_id
     * @property int|null $assign_cpd_id
     * @property int|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $end_date attribute
     * @property ModelsUser|null $addedBy
     * @method BelongsTo|Models_IH_User_QB addedBy()
     * @property Course|null $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property Cpd|null $cpd
     * @method BelongsTo|_IH_Cpd_QB cpd()
     * @property Course|null $quiz
     * @method BelongsTo|_IH_Course_QB quiz()
     * @property ModelsUser|null $student
     * @method BelongsTo|Models_IH_User_QB student()
     * @method static _IH_AssignStudent_QB onWriteConnection()
     * @method _IH_AssignStudent_QB newQuery()
     * @method static _IH_AssignStudent_QB on(null|string $connection = null)
     * @method static _IH_AssignStudent_QB query()
     * @method static _IH_AssignStudent_QB with(array|string $relations)
     * @method _IH_AssignStudent_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AssignStudent_C|AssignStudent[] all()
     * @ownLinks cpd_id,\Modules\CPD\Entities\Cpd,id|course_id,\Modules\CourseSetting\Entities\Course,id
     * @mixin _IH_AssignStudent_QB
     */
    class AssignStudent extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property int|null $status
     * @property int|null $created_by
     * @property int|null $certificate_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $end_date attribute
     * @property-read mixed[] $translations attribute
     * @property _IH_AssignCpdCourse_C|AssignCpdCourse[] $cpdCourses
     * @property-read int $cpd_courses_count
     * @method HasMany|_IH_AssignCpdCourse_QB cpdCourses()
     * @property CertificateRecord $hasCertificate
     * @method HasOne|_IH_CertificateRecord_QB hasCertificate()
     * @property _IH_AssignStudent_C|AssignStudent[] $studentCpdCourses
     * @property-read int $student_cpd_courses_count
     * @method HasMany|_IH_AssignStudent_QB studentCpdCourses()
     * @property _IH_AssignStudent_C|AssignStudent[] $students
     * @property-read int $students_count
     * @method HasMany|_IH_AssignStudent_QB students()
     * @property User|null $userInfo
     * @method BelongsTo|_IH_User_QB userInfo()
     * @method static _IH_Cpd_QB onWriteConnection()
     * @method _IH_Cpd_QB newQuery()
     * @method static _IH_Cpd_QB on(null|string $connection = null)
     * @method static _IH_Cpd_QB query()
     * @method static _IH_Cpd_QB with(array|string $relations)
     * @method _IH_Cpd_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Cpd_C|Cpd[] all()
     * @ownLinks certificate_id,\Modules\Certificate\Entities\Certificate,id
     * @foreignLinks id,\Modules\Certificate\Entities\CertificateRecord,cpd_id|id,\Modules\CPD\Entities\AssignStudent,cpd_id|id,\Modules\CPD\Entities\AssignCpdCourse,cpd_id
     * @mixin _IH_Cpd_QB
     */
    class Cpd extends Model {}
    
    /**
     * @property int $id
     * @property int|null $add_to_cpd
     * @property int|null $end_day
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_CpdSettings_QB onWriteConnection()
     * @method _IH_CpdSettings_QB newQuery()
     * @method static _IH_CpdSettings_QB on(null|string $connection = null)
     * @method static _IH_CpdSettings_QB query()
     * @method static _IH_CpdSettings_QB with(array|string $relations)
     * @method _IH_CpdSettings_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CpdSettings_C|CpdSettings[] all()
     * @mixin _IH_CpdSettings_QB
     */
    class CpdSettings extends Model {}
}