<?php //87a21f894bd27eb38ee6d9815471085e
/** @noinspection all */

namespace Modules\Cashback\Entities {

    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\Cashback\Entities\_IH_CashbackRuleUser_C;
    use LaravelIdea\Helper\Modules\Cashback\Entities\_IH_CashbackRuleUser_QB;
    use LaravelIdea\Helper\Modules\Cashback\Entities\_IH_CashbackRule_C;
    use LaravelIdea\Helper\Modules\Cashback\Entities\_IH_CashbackRule_QB;
    use LaravelIdea\Helper\Modules\Cashback\Entities\_IH_RuleSpecificItemDetail_C;
    use LaravelIdea\Helper\Modules\Cashback\Entities\_IH_RuleSpecificItemDetail_QB;
    use LaravelIdea\Helper\Modules\Cashback\Entities\_IH_RuleSpecificItem_C;
    use LaravelIdea\Helper\Modules\Cashback\Entities\_IH_RuleSpecificItem_QB;
    use LaravelIdea\Helper\Modules\Cashback\Entities\_IH_UserCashbackDetail_C;
    use LaravelIdea\Helper\Modules\Cashback\Entities\_IH_UserCashbackDetail_QB;
    use LaravelIdea\Helper\Modules\Cashback\Entities\_IH_UserCashback_C;
    use LaravelIdea\Helper\Modules\Cashback\Entities\_IH_UserCashback_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Category_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_CourseEnrolled_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use Modules\CourseSetting\Entities\Category;
    use Modules\CourseSetting\Entities\Course;
    use Modules\CourseSetting\Entities\CourseEnrolled;
    
    /**
     * @property int $id
     * @property string $title
     * @property string|null $user_type
     * @property Carbon|null $start_datetime
     * @property Carbon|null $end_datetime
     * @property float $amount
     * @property string|null $amount_type
     * @property float $min_purchase_amount
     * @property bool $apply_cashback_per_item
     * @property bool $status
     * @property Carbon|null $deleted_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $status_text attribute
     * @property-read mixed[] $translations attribute
     * @property RuleSpecificItem $rule_specific_item
     * @method HasOne|_IH_RuleSpecificItem_QB rule_specific_item()
     * @property _IH_UserCashbackDetail_C|UserCashbackDetail[] $userCashbackDetails
     * @property-read int $user_cashback_details_count
     * @method HasMany|_IH_UserCashbackDetail_QB userCashbackDetails()
     * @property _IH_CashbackRuleUser_C|CashbackRuleUser[] $users
     * @property-read int $users_count
     * @method HasMany|_IH_CashbackRuleUser_QB users()
     * @method static _IH_CashbackRule_QB onWriteConnection()
     * @method _IH_CashbackRule_QB newQuery()
     * @method static _IH_CashbackRule_QB on(null|string $connection = null)
     * @method static _IH_CashbackRule_QB query()
     * @method static _IH_CashbackRule_QB with(array|string $relations)
     * @method _IH_CashbackRule_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CashbackRule_C|CashbackRule[] all()
     * @foreignLinks id,\Modules\Cashback\Entities\RuleSpecificItem,rule_id|id,\Modules\Cashback\Entities\UserCashbackDetail,rule_id|id,\Modules\Cashback\Entities\CashbackRuleUser,cashback_rule_id
     * @mixin _IH_CashbackRule_QB
     */
    class CashbackRule extends Model {}
    
    /**
     * @property int $id
     * @property int $cashback_rule_id
     * @property int $user_id
     * @property int|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_CashbackRuleUser_QB onWriteConnection()
     * @method _IH_CashbackRuleUser_QB newQuery()
     * @method static _IH_CashbackRuleUser_QB on(null|string $connection = null)
     * @method static _IH_CashbackRuleUser_QB query()
     * @method static _IH_CashbackRuleUser_QB with(array|string $relations)
     * @method _IH_CashbackRuleUser_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CashbackRuleUser_C|CashbackRuleUser[] all()
     * @ownLinks cashback_rule_id,\Modules\Cashback\Entities\CashbackRule,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_CashbackRuleUser_QB
     */
    class CashbackRuleUser extends Model {}
    
    /**
     * @property int $id
     * @property int $rule_id
     * @property string $target_type
     * @property string|null $target
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_RuleSpecificItemDetail_C|RuleSpecificItemDetail[] $rule_specific_item_details
     * @property-read int $rule_specific_item_details_count
     * @method HasMany|_IH_RuleSpecificItemDetail_QB rule_specific_item_details()
     * @property _IH_RuleSpecificItemDetail_C|RuleSpecificItemDetail[] $rule_specific_item_details_relation
     * @property-read int $rule_specific_item_details_relation_count
     * @method HasMany|_IH_RuleSpecificItemDetail_QB rule_specific_item_details_relation()
     * @method static _IH_RuleSpecificItem_QB onWriteConnection()
     * @method _IH_RuleSpecificItem_QB newQuery()
     * @method static _IH_RuleSpecificItem_QB on(null|string $connection = null)
     * @method static _IH_RuleSpecificItem_QB query()
     * @method static _IH_RuleSpecificItem_QB with(array|string $relations)
     * @method _IH_RuleSpecificItem_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RuleSpecificItem_C|RuleSpecificItem[] all()
     * @ownLinks rule_id,\Modules\Cashback\Entities\CashbackRule,id
     * @foreignLinks id,\Modules\Cashback\Entities\RuleSpecificItemDetail,rule_specific_item_id
     * @mixin _IH_RuleSpecificItem_QB
     */
    class RuleSpecificItem extends Model {}
    
    /**
     * @property int $id
     * @property int $rule_specific_item_id
     * @property string $type
     * @property int $item_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Category $itemInfo
     * @method BelongsTo|_IH_Category_QB itemInfo()
     * @property RuleSpecificItem $rule_specific_item
     * @method BelongsTo|_IH_RuleSpecificItem_QB rule_specific_item()
     * @method static _IH_RuleSpecificItemDetail_QB onWriteConnection()
     * @method _IH_RuleSpecificItemDetail_QB newQuery()
     * @method static _IH_RuleSpecificItemDetail_QB on(null|string $connection = null)
     * @method static _IH_RuleSpecificItemDetail_QB query()
     * @method static _IH_RuleSpecificItemDetail_QB with(array|string $relations)
     * @method _IH_RuleSpecificItemDetail_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RuleSpecificItemDetail_C|RuleSpecificItemDetail[] all()
     * @ownLinks rule_specific_item_id,\Modules\Cashback\Entities\RuleSpecificItem,id
     * @mixin _IH_RuleSpecificItemDetail_QB
     */
    class RuleSpecificItemDetail extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property float $purchase_amount
     * @property float $cashback_amount
     * @property Carbon|null $last_cashback_datetime
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_UserCashbackDetail_C|UserCashbackDetail[] $cashbackDetails
     * @property-read int $cashback_details_count
     * @method HasMany|_IH_UserCashbackDetail_QB cashbackDetails()
     * @property CashbackRule $cashback_rule
     * @method BelongsTo|_IH_CashbackRule_QB cashback_rule()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_UserCashback_QB onWriteConnection()
     * @method _IH_UserCashback_QB newQuery()
     * @method static _IH_UserCashback_QB on(null|string $connection = null)
     * @method static _IH_UserCashback_QB query()
     * @method static _IH_UserCashback_QB with(array|string $relations)
     * @method _IH_UserCashback_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserCashback_C|UserCashback[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @foreignLinks id,\Modules\Cashback\Entities\UserCashbackDetail,user_cashback_id
     * @mixin _IH_UserCashback_QB
     */
    class UserCashback extends Model {}
    
    /**
     * @property int $id
     * @property int $user_cashback_id
     * @property int $rule_id
     * @property string $product_type
     * @property int $product_id
     * @property float $purchase_amount
     * @property float $cashback_amount
     * @property Carbon|null $cashback_datetime
     * @property string|null $description
     * @property string $status
     * @property Carbon|null $refunded_datetime
     * @property string|null $refunded_description
     * @property int|null $is_gift
     * @property int|null $gift_id
     * @property int|null $gifted_to
     * @property int|null $subscription_enrolled_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Course $course_info
     * @method BelongsTo|_IH_Course_QB course_info()
     * @property Course $product_info
     * @method BelongsTo|_IH_Course_QB product_info()
     * @property CourseEnrolled|null $subscription_info
     * @method BelongsTo|_IH_CourseEnrolled_QB subscription_info()
     * @property UserCashback $user_cashback
     * @method BelongsTo|_IH_UserCashback_QB user_cashback()
     * @method static _IH_UserCashbackDetail_QB onWriteConnection()
     * @method _IH_UserCashbackDetail_QB newQuery()
     * @method static _IH_UserCashbackDetail_QB on(null|string $connection = null)
     * @method static _IH_UserCashbackDetail_QB query()
     * @method static _IH_UserCashbackDetail_QB with(array|string $relations)
     * @method _IH_UserCashbackDetail_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserCashbackDetail_C|UserCashbackDetail[] all()
     * @ownLinks user_cashback_id,\Modules\Cashback\Entities\UserCashback,id|rule_id,\Modules\Cashback\Entities\CashbackRule,id|product_id,\Modules\Store\Entities\Product,id
     * @mixin _IH_UserCashbackDetail_QB
     */
    class UserCashbackDetail extends Model {}
}