<!-- sidebar part here -->
@if(auth()->user()->student_type == 'membership' && isModuleActive('Membership'))
    @includeIf('membership::membership_member_menu')
@else
    <nav class="sidebar">
        <div class="logo d-flex justify-content-between">
            <a href="{{url('/')}}"><img
                    src="{{getCourseImage(Settings('logo3')?Settings('logo3'):'public/uploads/settings/logo1.png')}}"
                    alt=""></a>
            <div class="sidebar_close_icon d-lg-none">
                <i class="ti-close"></i>
            </div>
        </div>
        <div class="sidebar_iner">
            <div class="sidebar-user text-center">
                <div class="sidebar-profile mx-auto">
                    <img src="{{getProfileImage(\Illuminate\Support\Facades\Auth::user()->image,Auth::user()->name)}}"
                         alt="">
                </div>
                <h4>{{\Illuminate\Support\Facades\Auth::user()->name}}</h4>
                @if(isModuleActive('UserGroup') && \Illuminate\Support\Facades\Auth::user()->userGroup  && \Illuminate\Support\Facades\Auth::user()->userGroup->group->status)
                    <p class="text-nowrap mb-2">{{\Illuminate\Support\Facades\Auth::user()->userGroup->group->title}}</p>
                @endif

                <div class="sidebar-badge">
                    @php
                        $already=[];
                    @endphp
                    @foreach(\Illuminate\Support\Facades\Auth::user()->userLatestBadges as $badge)
                        @php
                            $b =$badge->badge;

                            if (in_array($b->type,$already)){
                                continue;
                            }else{
                                $already[]=$b->type;
                            }
                        @endphp
                        <div class="sidebar-badge-list"
                             data-bs-toggle="tooltip" data-placement="top"
                             title="{{$b->title}} {{ucfirst($b->type)}} {{trans('setting.Badge')}}">
                            <img
                                src="{{asset($b->image)}}" alt=""></div>
                    @endforeach

                </div>
            </div>
            <!-- new sidebar end -->

            <ul class="list-unstyled pt-0">
                @if (permissionCheck('studentDashboard'))
                    <li>
                        <a href="{{route('studentDashboard')}}"
                           class="  d-flex align-items-center {{ routeIs('studentDashboard')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="20" height="19" viewBox="0 0 20 19" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M6.41195 17.4569H13.5879M10 13.0596V17.4568M1.50594 11.9531C1.61557 12.6863 2.25091 13.2334 2.99191 13.2112C5.26257 13.1432 7.57577 13.0558 10 13.0558C12.4148 13.0558 14.7284 13.1106 16.9859 13.1946C17.7363 13.2225 18.3863 12.6732 18.4974 11.9307C18.7299 10.3787 19 8.76171 19 7.10032C19 5.44472 18.7317 3.83323 18.4999 2.28621C18.3876 1.53697 17.7269 0.98605 16.97 1.01785C14.7382 1.11158 12.4034 1.1448 10 1.1448C7.58686 1.1448 5.25183 1.07941 3.00726 1.0009C2.2598 0.974746 1.61432 1.52337 1.50361 2.26304C1.27101 3.81715 1 5.43646 1 7.10032C1 8.76973 1.27282 10.3943 1.50594 11.9531Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"/>
                                </svg>

                            </div>
                            <span>{{__('common.Dashboard')}}</span>
                        </a>
                    </li>
                @endif
                @if (permissionCheck('myCourses'))

                    <li>
                        <a href="{{route('myCourses')}}"
                           class=" d-flex align-items-center {{ routeIs('myCourses')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M1.56522 17.0853L2.41747 16.9939L2.41747 16.9939L1.56522 17.0853ZM2.88839 18.4096L2.79522 19.2617L2.79525 19.2617L2.88839 18.4096ZM17.1116 18.4096L17.2047 19.2617L17.2048 19.2617L17.1116 18.4096ZM18.4347 17.0853L17.5825 16.9939L17.5825 16.9939L18.4347 17.0853ZM18.4347 2.91458L17.5825 3.00598L17.5825 3.00606L18.4347 2.91458ZM17.1116 1.59035L17.2047 0.738282L17.2047 0.738282L17.1116 1.59035ZM2.88839 1.59035L2.79524 0.738282L2.79524 0.738282L2.88839 1.59035ZM1.56522 2.91458L2.41747 3.00606L2.41747 3.00605L1.56522 2.91458ZM7.16077 12.9275L8.00927 12.8061L8.00927 12.8061L7.16077 12.9275ZM8.90002 14.0151L9.18733 14.8227L9.18734 14.8227L8.90002 14.0151ZM13.8112 10.7265L13.1359 10.1986L13.1359 10.1986L13.8112 10.7265ZM13.8113 9.27309L14.4866 8.74525L14.4866 8.74525L13.8113 9.27309ZM8.9001 5.98451L8.61279 6.79207L8.6128 6.79207L8.9001 5.98451ZM7.16087 7.07204L6.31237 6.9506L6.31237 6.95062L7.16087 7.07204ZM0.712974 17.1768C0.830796 18.2746 1.70007 19.1419 2.79522 19.2617L2.98157 17.5576C2.68457 17.5251 2.4491 17.2885 2.41747 16.9939L0.712974 17.1768ZM2.79525 19.2617C5.03182 19.5062 7.48472 19.8571 9.99999 19.8571V18.1429C7.60672 18.1429 5.29438 17.8104 2.98153 17.5576L2.79525 19.2617ZM9.99999 19.8571C12.5153 19.8571 14.9682 19.5062 17.2047 19.2617L17.0184 17.5576C14.7056 17.8104 12.3933 18.1429 9.99999 18.1429V19.8571ZM17.2048 19.2617C18.2999 19.1419 19.1692 18.2746 19.287 17.1767L17.5825 16.9939C17.5509 17.2885 17.3154 17.5251 17.0184 17.5576L17.2048 19.2617ZM19.287 17.1768C19.5268 14.9427 19.8571 12.5044 19.8571 9.99999H18.1429C18.1429 12.3859 17.8292 14.6952 17.5825 16.9939L19.287 17.1768ZM19.8571 9.99999C19.8571 7.49557 19.5268 5.05724 19.287 2.82309L17.5825 3.00606C17.8292 5.30471 18.1429 7.61405 18.1429 9.99999H19.8571ZM19.287 2.82318C19.1692 1.72531 18.2998 0.858012 17.2047 0.738282L17.0184 2.44241C17.3155 2.47489 17.5509 2.71141 17.5825 3.00598L19.287 2.82318ZM17.2047 0.738282C14.9682 0.49377 12.5153 0.142857 9.99999 0.142857V1.85714C12.3933 1.85714 14.7057 2.18957 17.0184 2.44241L17.2047 0.738282ZM9.99999 0.142857C7.48471 0.142857 5.03185 0.49377 2.79524 0.738282L2.98154 2.44241C5.29435 2.18957 7.60672 1.85714 9.99999 1.85714V0.142857ZM2.79524 0.738282C1.70011 0.858014 0.830799 1.72532 0.712974 2.82311L2.41747 3.00605C2.44909 2.7114 2.68454 2.47489 2.98155 2.44241L2.79524 0.738282ZM0.712975 2.8231C0.473165 5.05726 0.142857 7.49557 0.142857 9.99999H1.85714C1.85714 7.61404 2.17074 5.30469 2.41747 3.00606L0.712975 2.8231ZM0.142857 9.99999C0.142857 12.5044 0.473165 14.9427 0.712975 17.1768L2.41747 16.9939C2.17074 14.6952 1.85714 12.3859 1.85714 9.99999H0.142857ZM6.0296 9.99981C6.0296 10.8832 6.17791 12.1097 6.31226 13.0489L8.00927 12.8061C7.87486 11.8665 7.74389 10.7483 7.74389 9.99981H6.0296ZM6.31226 13.0489C6.50305 14.3826 7.84723 15.2995 9.18733 14.8227L8.6127 13.2076C8.36351 13.2962 8.05736 13.1423 8.00927 12.8061L6.31226 13.0489ZM9.18734 14.8227C11.188 14.1108 13.1288 12.9913 14.4865 11.2544L13.1359 10.1986C12.0454 11.5937 10.4284 12.5616 8.61269 13.2076L9.18734 14.8227ZM14.4865 11.2544C15.0634 10.5163 15.0635 9.48332 14.4866 8.74525L13.1359 9.80093C13.228 9.91868 13.228 10.0809 13.1359 10.1986L14.4865 11.2544ZM14.4866 8.74525C13.129 7.00823 11.1881 5.88873 9.18741 5.17695L8.6128 6.79207C10.4285 7.43804 12.0455 8.40582 13.1359 9.80093L14.4866 8.74525ZM9.18741 5.17695C7.84736 4.70019 6.50325 5.61697 6.31237 6.9506L8.00937 7.19348C8.05748 6.85729 8.36362 6.70341 8.61279 6.79207L9.18741 5.17695ZM6.31237 6.95062C6.17797 7.88984 6.0296 9.11642 6.0296 9.99981H7.74389C7.74389 9.25128 7.87491 8.13308 8.00937 7.19346L6.31237 6.95062Z"
                                        fill="currentColor"/>
                                </svg>
                            </div>
                            <span>{{__('common.My Courses')}}</span>
                        </a>
                    </li>
                @endif
                @if (permissionCheck('myQuizzes'))
                    <li>
                        <a href="{{route('myQuizzes')}}"
                           class=" d-flex align-items-center {{ routeIs('myQuizzes')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M18.4664 11.8311C18.4659 11.3596 18.3414 10.8966 18.1053 10.4885C17.8693 10.0804 17.5301 9.74156 17.1215 9.50605C16.7132 9.27052 16.2501 9.14661 15.7786 9.14673C15.3071 9.14684 15.088 9.2717 14.6797 9.50743L14.4356 6.37898C14.4356 6.02264 14.2941 5.6809 14.0421 5.42894C13.7902 5.17697 13.4484 5.03542 13.0921 5.03542L10.3391 4.7394C10.576 4.33098 10.7052 4.16341 10.7059 3.69126C10.7067 3.2191 10.583 2.75509 10.3473 2.34594C10.1117 1.93681 9.77234 1.59698 9.36357 1.36069C8.9548 1.12441 8.49097 1 8.01881 1C7.54666 1 7.08284 1.12441 6.67405 1.36069C6.26528 1.59698 5.92597 1.93681 5.69031 2.34594C5.45466 2.75509 5.33096 3.2191 5.33168 3.69126C5.33241 4.16341 5.4534 4.33098 5.69031 4.7394L2.34356 5.03542C1.98723 5.03542 1.64549 5.17697 1.39352 5.42894C1.14155 5.6809 1 6.02264 1 6.37898L1.04192 7.91162C1.06039 8.58661 1.72253 9.06577 2.37884 9.22459C2.8543 9.33963 3.29845 9.57976 3.64971 9.93101C4.15364 10.435 4.43675 11.1184 4.43675 11.8311C4.43675 12.5438 4.15364 13.2273 3.64971 13.7312C3.29845 14.0824 2.8543 14.3226 2.37884 14.4377C1.72214 14.5965 1.05939 15.0752 1.03985 15.7505L1 17.1274C1 17.4838 1.14155 17.8256 1.39352 18.0776C3.35197 19.3723 12.3474 19.2409 14.0421 18.0776C14.2941 17.8256 14.4356 17.4838 14.4356 17.1274L14.6797 14.1562C15.088 14.3919 15.3071 14.5153 15.7786 14.5154C16.2501 14.5156 16.7132 14.3917 17.1215 14.1562C17.5301 13.9206 17.8693 13.5818 18.1053 13.1737C18.3414 12.7656 18.4659 12.3026 18.4664 11.8311Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                </svg>

                            </div>
                            <span>{{__('common.My Quizzes')}}</span>
                        </a>
                    </li>
                @endif
                @if (permissionCheck('myClasses'))

                    <li>
                        <a href="{{route('myClasses')}}"
                           class=" d-flex align-items-center {{ routeIs('myClasses')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="19" height="20" viewBox="0 0 19 20" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M16.0041 9.53454L16.4999 8.83534L16.4998 8.83533L16.0041 9.53454ZM16.3614 13.273L15.8413 12.5917L15.8413 12.5918L16.3614 13.273ZM12.1644 15.0989L12.3082 15.9439L12.3082 15.9439L12.1644 15.0989ZM5.03038 13.4729L4.5346 14.1721L4.53461 14.1721L5.03038 13.4729ZM1.1356 7.27869L0.290615 7.42252L0.290616 7.42252L1.1356 7.27869ZM1.46997 2.7139L0.654958 2.44848L0.654957 2.44849L1.46997 2.7139ZM5.11618 1.81429L4.62039 2.51349L4.6204 2.51349L5.11618 1.81429ZM4.92924 13.3289C5.20192 12.942 5.10927 12.4072 4.7223 12.1346C4.33533 11.8619 3.80059 11.9545 3.52791 12.3415L4.92924 13.3289ZM1.491 16.7203L0.790335 16.2265L0.790327 16.2266L1.491 16.7203ZM2.66917 18.9948L2.67013 18.1377H2.67013L2.66917 18.9948ZM7.34144 19L7.34049 19.8571H7.34054L7.34144 19ZM8.60896 16.8636L9.36082 16.452L9.3608 16.4519L8.60896 16.8636ZM8.17697 14.2897C7.94963 13.8745 7.42873 13.7221 7.0135 13.9495C6.59828 14.1768 6.44596 14.6977 6.6733 15.1129L8.17697 14.2897ZM13.7684 3.8697C13.4945 4.25575 13.5853 4.7908 13.9714 5.06478C14.3574 5.33875 14.8925 5.24789 15.1664 4.86184L13.7684 3.8697ZM13.6148 1.52402L14.1108 0.825008L14.1108 0.824968L13.6148 1.52402ZM9.95174 1.1615C9.6778 1.54757 9.76869 2.08261 10.1548 2.35656C10.5408 2.63051 11.0759 2.53961 11.3498 2.15354L9.95174 1.1615ZM15.5083 10.2337C15.9704 10.5615 16.24 11.0424 16.2947 11.4906C16.3469 11.9187 16.209 12.311 15.8413 12.5917L16.8815 13.9543C17.781 13.2677 18.1145 12.2518 17.9964 11.283C17.8807 10.3343 17.338 9.42969 16.4999 8.83534L15.5083 10.2337ZM15.8413 12.5918C14.7312 13.4393 13.4227 14.0152 12.0205 14.2539L12.3082 15.9439C13.9866 15.6582 15.5529 14.9688 16.8815 13.9543L15.8413 12.5918ZM12.0205 14.2539C9.74513 14.6413 7.40903 14.1088 5.52616 12.7737L4.53461 14.1721C6.78832 15.7701 9.58457 16.4075 12.3082 15.9439L12.0205 14.2539ZM5.52617 12.7737C3.64331 11.4386 2.36792 9.41029 1.98059 7.13485L0.290616 7.42252C0.754245 10.1462 2.28085 12.5741 4.5346 14.1721L5.52617 12.7737ZM1.98059 7.13485C1.74191 5.73265 1.85249 4.30742 2.28499 2.97931L0.654957 2.44849C0.137316 4.03805 0.00491142 5.74407 0.290615 7.42252L1.98059 7.13485ZM2.28499 2.97931C2.42822 2.53949 2.75282 2.2795 3.1741 2.18714C3.61513 2.09044 4.15818 2.18574 4.62039 2.51349L5.61197 1.11508C4.77378 0.520735 3.74053 0.307941 2.80697 0.512625C1.85366 0.721638 1.00536 1.37251 0.654958 2.44848L2.28499 2.97931ZM4.6204 2.51349L15.5083 10.2337L16.4998 8.83533L5.61197 1.11508L4.6204 2.51349ZM3.52791 12.3415L0.790335 16.2265L2.19167 17.214L4.92924 13.3289L3.52791 12.3415ZM0.790327 16.2266C-0.282858 17.7496 0.805065 19.8499 2.66822 19.8519L2.67013 18.1377C2.19541 18.1371 1.91823 17.602 2.19168 17.214L0.790327 16.2266ZM2.66822 19.8519L7.34049 19.8571L7.34239 18.1429L2.67013 18.1377L2.66822 19.8519ZM7.34054 19.8571C9.08934 19.859 10.2006 17.986 9.36082 16.452L7.8571 17.2752C8.07112 17.6661 7.78793 18.1433 7.34234 18.1429L7.34054 19.8571ZM9.3608 16.4519L8.17697 14.2897L6.6733 15.1129L7.85713 17.2752L9.3608 16.4519ZM15.1664 4.86184C16.1314 3.50207 15.3786 1.72469 14.1108 0.825008L13.1187 2.22304C13.9586 2.8191 13.9696 3.58628 13.7684 3.8697L15.1664 4.86184ZM14.1108 0.824968C12.8428 -0.0747155 10.9166 -0.198226 9.95174 1.1615L11.3498 2.15354C11.551 1.87009 12.2787 1.62705 13.1188 2.22308L14.1108 0.824968Z"
                                        fill="currentColor"/>
                                </svg>

                            </div>
                            <span>{{__('common.Live Classes')}}</span>
                        </a>
                    </li>
                @endif
                @if (isModuleActive('Gift'))

                    <li>
                        <a href="{{route('gift.myGifts')}}"
                           class=" d-flex align-items-center {{ routeIs('gift.myGifts')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="18" height="20" viewBox="0 0 18 20" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M4.70495 18.8625L4.76695 18.0076L4.76694 18.0076L4.70495 18.8625ZM13.3792 18.8625L13.3172 18.0076L13.3172 18.0076L13.3792 18.8625ZM16.9653 15.2749L17.8196 15.3444L17.8196 15.3442L16.9653 15.2749ZM16.9653 9.56532L16.1109 9.63471V9.63471L16.9653 9.56532ZM13.3792 5.97769L13.3172 6.83258L13.3172 6.83258L13.3792 5.97769ZM4.70495 5.97769L4.76695 6.83258L4.76696 6.83258L4.70495 5.97769ZM1.11898 9.56532L1.97331 9.63471L1.97331 9.63471L1.11898 9.56532ZM1.11898 15.2749L0.264652 15.3443L0.264652 15.3443L1.11898 15.2749ZM9.04202 5.81295L8.31398 6.26534C8.47038 6.51703 8.74569 6.67009 9.04202 6.67009C9.33835 6.67009 9.61366 6.51703 9.77006 6.26534L9.04202 5.81295ZM11.3245 2.13965L12.0526 2.59204L12.0526 2.59204L11.3245 2.13965ZM15.5194 2.27772L14.7629 2.68065L14.7629 2.68067L15.5194 2.27772ZM14.4419 5.55281L14.0686 4.78124L14.0685 4.78125L14.4419 5.55281ZM13.1704 5.21584C12.7443 5.42203 12.566 5.93463 12.7722 6.36075C12.9784 6.78687 13.491 6.96515 13.9171 6.75895L13.1704 5.21584ZM6.75952 2.13965L6.03148 2.59204L6.03148 2.59204L6.75952 2.13965ZM2.56453 2.27772L3.32106 2.68066L3.32106 2.68065L2.56453 2.27772ZM3.64208 5.55281L3.26875 6.32438L3.26876 6.32438L3.64208 5.55281ZM4.16693 6.75897C4.59306 6.96515 5.10565 6.78685 5.31183 6.36072C5.51801 5.9346 5.33971 5.42201 4.91358 5.21582L4.16693 6.75897ZM4.64294 19.7174C5.95759 19.8128 7.40943 19.8571 9.04208 19.8571V18.1429C7.43922 18.1429 6.03019 18.0993 4.76695 18.0076L4.64294 19.7174ZM9.04208 19.8571C10.6747 19.8571 12.1266 19.8128 13.4412 19.7174L13.3172 18.0076C12.054 18.0993 10.645 18.1429 9.04208 18.1429V19.8571ZM13.4412 19.7174C15.7971 19.5466 17.6298 17.6794 17.8196 15.3444L16.1109 15.2055C15.988 16.7171 14.8105 17.8994 13.3172 18.0076L13.4412 19.7174ZM17.8196 15.3442C17.8969 14.3906 17.9412 13.4168 17.9412 12.42H16.227C16.227 13.3658 16.1849 14.2932 16.1109 15.2057L17.8196 15.3442ZM17.9412 12.42C17.9412 11.4234 17.8971 10.4496 17.8196 9.49592L16.1109 9.63471C16.185 10.5469 16.227 11.4742 16.227 12.42H17.9412ZM17.8196 9.49593C17.6299 7.1608 15.7971 5.29365 13.4412 5.12279L13.3172 6.83258C14.8106 6.94089 15.9882 8.12318 16.1109 9.63471L17.8196 9.49593ZM13.4412 5.12279C12.1266 5.02742 10.6747 4.98312 9.04208 4.98312V6.69741C10.645 6.69741 12.054 6.74095 13.3172 6.83258L13.4412 5.12279ZM9.04208 4.98312C7.40945 4.98312 5.9576 5.02742 4.64293 5.12279L4.76696 6.83258C6.03018 6.74095 7.4392 6.69741 9.04208 6.69741V4.98312ZM4.64295 5.12279C2.28705 5.29365 0.454306 7.16083 0.264652 9.49593L1.97331 9.63471C2.09608 8.12315 3.2736 6.94089 4.76695 6.83258L4.64295 5.12279ZM0.264652 9.49592C0.187194 10.4495 0.142857 11.4234 0.142857 12.42H1.85714C1.85714 11.4743 1.89921 10.547 1.97331 9.63471L0.264652 9.49592ZM0.142857 12.42C0.142857 13.4168 0.187194 14.3906 0.264652 15.3443L1.97331 15.2056C1.89921 14.2932 1.85714 13.3658 1.85714 12.42H0.142857ZM0.264652 15.3443C0.454306 17.6794 2.28704 19.5466 4.64296 19.7174L4.76694 18.0076C3.27361 17.8994 2.09608 16.7171 1.97331 15.2056L0.264652 15.3443ZM1 11.815H17.0841V10.1007H1V11.815ZM9.89922 19V5.84026H8.18493V19H9.89922ZM9.77006 6.26534L12.0526 2.59204L10.5965 1.68727L8.31398 5.36057L9.77006 6.26534ZM12.0526 2.59204C12.6857 1.57304 14.2002 1.62413 14.7629 2.68065L16.276 1.87479C15.0914 -0.349321 11.9259 -0.45225 10.5965 1.68727L12.0526 2.59204ZM14.7629 2.68067C15.1702 3.44537 14.8617 4.39747 14.0686 4.78124L14.8152 6.32439C16.4767 5.52049 17.1445 3.50534 16.276 1.87477L14.7629 2.68067ZM14.0685 4.78125L13.1704 5.21584L13.9171 6.75895L14.8152 6.32437L14.0685 4.78125ZM9.77006 5.36057L7.48756 1.68727L6.03148 2.59204L8.31398 6.26534L9.77006 5.36057ZM7.48756 1.68727C6.15812 -0.452245 2.99255 -0.349329 1.80799 1.87479L3.32106 2.68065C3.88375 1.62414 5.3983 1.57303 6.03148 2.59204L7.48756 1.68727ZM1.808 1.87479C0.93955 3.50534 1.60731 5.52048 3.26875 6.32438L4.01541 4.78124C3.22229 4.39748 2.91376 3.44537 3.32106 2.68066L1.808 1.87479ZM3.26876 6.32438L4.16693 6.75897L4.91358 5.21582L4.01541 4.78124L3.26876 6.32438Z"
                                        fill="currentColor"/>
                                </svg>

                            </div>
                            <span>{{_trans('gift.Gifts')}}</span>
                        </a>
                    </li>
                @endif

                @if(permissionCheck('users.blog.index'))
                    <li>
                        <a href="{{ route('users.blog.index') }}"
                           class="{{ routeIs('users.blog.index')  ? 'active' : '' }} d-flex align-items-center ">
                            <div class="menu_icon">

                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M19.2178 8.93844L19.1005 9.67921H19.1005L19.2178 8.93844ZM15.0616 4.78217L14.3208 4.8995V4.8995L15.0616 4.78217ZM5.06107 20.0451L5.50191 19.4383L5.06107 20.0451ZM3.95491 18.9389L4.56168 18.4981L3.95491 18.9389ZM20.0451 18.9389L19.4383 18.4981L20.0451 18.9389ZM18.9389 20.0451L18.4981 19.4383L18.9389 20.0451ZM18.9389 3.95491L19.3798 3.34815L18.9389 3.95491ZM20.0451 5.06107L20.6518 4.62023L20.0451 5.06107ZM5.06107 3.95491L5.50191 4.56168L5.06107 3.95491ZM3.95491 5.06107L4.56168 5.50191L3.95491 5.06107ZM15 3.02893L15.0257 2.27937L15 3.02893ZM20.9711 9L21.7206 8.97432L20.9711 9ZM8 15.25C7.58579 15.25 7.25 15.5858 7.25 16C7.25 16.4142 7.58579 16.75 8 16.75V15.25ZM11 16.75C11.4142 16.75 11.75 16.4142 11.75 16C11.75 15.5858 11.4142 15.25 11 15.25V16.75ZM8 11.25C7.58579 11.25 7.25 11.5858 7.25 12C7.25 12.4142 7.58579 12.75 8 12.75V11.25ZM16 12.75C16.4142 12.75 16.75 12.4142 16.75 12C16.75 11.5858 16.4142 11.25 16 11.25V12.75ZM8 7.25C7.58579 7.25 7.25 7.58579 7.25 8C7.25 8.41421 7.58579 8.75 8 8.75V7.25ZM11 8.75C11.4142 8.75 11.75 8.41421 11.75 8C11.75 7.58579 11.4142 7.25 11 7.25V8.75ZM19.3352 8.19768C17.5166 7.90965 16.0904 6.48339 15.8023 4.66485L14.3208 4.8995C14.7105 7.35988 16.6401 9.28952 19.1005 9.67921L19.3352 8.19768ZM12 20.25C10.1084 20.25 8.74999 20.249 7.69804 20.135C6.66013 20.0225 6.00992 19.8074 5.50191 19.4383L4.62023 20.6518C5.42656 21.2377 6.37094 21.5 7.53648 21.6263C8.68798 21.751 10.1418 21.75 12 21.75V20.25ZM2.25 12C2.25 13.8582 2.24897 15.312 2.37373 16.4635C2.50001 17.6291 2.76232 18.5734 3.34815 19.3798L4.56168 18.4981C4.19259 17.9901 3.97745 17.3399 3.865 16.302C3.75103 15.25 3.75 13.8916 3.75 12H2.25ZM5.50191 19.4383C5.14111 19.1762 4.82382 18.8589 4.56168 18.4981L3.34815 19.3798C3.70281 19.8679 4.13209 20.2972 4.62023 20.6518L5.50191 19.4383ZM20.25 12C20.25 13.8916 20.249 15.25 20.135 16.302C20.0225 17.3399 19.8074 17.9901 19.4383 18.4981L20.6518 19.3798C21.2377 18.5734 21.5 17.6291 21.6263 16.4635C21.751 15.312 21.75 13.8582 21.75 12H20.25ZM12 21.75C13.8582 21.75 15.312 21.751 16.4635 21.6263C17.6291 21.5 18.5734 21.2377 19.3798 20.6518L18.4981 19.4383C17.9901 19.8074 17.3399 20.0225 16.302 20.135C15.25 20.249 13.8916 20.25 12 20.25V21.75ZM19.4383 18.4981C19.1762 18.8589 18.8589 19.1762 18.4981 19.4383L19.3798 20.6518C19.8679 20.2972 20.2972 19.8679 20.6518 19.3798L19.4383 18.4981ZM18.4981 4.56168C18.8589 4.82382 19.1762 5.14111 19.4383 5.50191L20.6518 4.62023C20.2972 4.13209 19.8679 3.70281 19.3798 3.34815L18.4981 4.56168ZM12 2.25C10.1418 2.25 8.68798 2.24897 7.53648 2.37373C6.37094 2.50001 5.42656 2.76232 4.62023 3.34815L5.50191 4.56168C6.00992 4.19259 6.66013 3.97745 7.69804 3.865C8.74999 3.75103 10.1084 3.75 12 3.75V2.25ZM3.75 12C3.75 10.1084 3.75103 8.74999 3.865 7.69804C3.97745 6.66013 4.19259 6.00992 4.56168 5.50191L3.34815 4.62023C2.76232 5.42656 2.50001 6.37094 2.37373 7.53648C2.24897 8.68798 2.25 10.1418 2.25 12H3.75ZM4.62023 3.34815C4.13209 3.70281 3.70281 4.13209 3.34815 4.62023L4.56168 5.50191C4.82382 5.14111 5.14111 4.82382 5.50191 4.56168L4.62023 3.34815ZM12 3.75C13.1731 3.75 14.1456 3.75009 14.9743 3.77849L15.0257 2.27937C14.1658 2.24991 13.1648 2.25 12 2.25V3.75ZM14.9743 3.77849C16.8292 3.84204 17.7925 4.04907 18.4981 4.56168L19.3798 3.34815C18.2761 2.5463 16.8991 2.34355 15.0257 2.27937L14.9743 3.77849ZM14.25 3.02893C14.25 3.91121 14.2484 4.44215 14.3208 4.8995L15.8023 4.66485C15.7529 4.35298 15.75 3.96617 15.75 3.02892L14.25 3.02893ZM21.75 12C21.75 10.8352 21.7501 9.83424 21.7206 8.97432L20.2215 9.02568C20.2499 9.85445 20.25 10.8269 20.25 12H21.75ZM21.7206 8.97432C21.6564 7.10087 21.4537 5.7239 20.6518 4.62023L19.4383 5.50191C19.9509 6.20746 20.158 7.17075 20.2215 9.02568L21.7206 8.97432ZM20.9711 8.25C20.0338 8.24999 19.647 8.24707 19.3352 8.19768L19.1005 9.67921C19.5579 9.75165 20.0888 9.74999 20.9711 9.75L20.9711 8.25ZM8 16.75H11V15.25H8V16.75ZM8 12.75H16V11.25H8V12.75ZM8 8.75H11V7.25H8V8.75Z"
                                        fill="currentColor"/>
                                </svg>

                            </div>
                            <span>{{_trans('blog.My Blogs')}}</span>
                        </a>
                    </li>
                @endif

                @if(isModuleActive('UpcomingCourse') && permissionCheck('upcoming_courses'))
                    @php
                        $upcoming_course_menu = false;
                        if(routeIs('upcoming_courses.my_following')
                        ||routeIs('upcoming_courses.my_booking')
                        ){
                            $upcoming_course_menu = true;
                        }
                    @endphp
                    <li>
                        <a class="d-flex justify-content-between align-items-center {{ $upcoming_course_menu  ? 'active' : '' }}"
                           data-bs-toggle="collapse" href="#collapseUpcomingCourse" role="button"
                           aria-expanded="{{$upcoming_course_menu?'true':'false'}}"
                           aria-controls="collapseUpcomingCourse">

                            <div class="d-flex align-items-center">
                                <div class="menu_icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M1.56522 17.0853L2.41747 16.9939L2.41747 16.9939L1.56522 17.0853ZM2.88839 18.4096L2.79522 19.2617L2.79525 19.2617L2.88839 18.4096ZM17.1116 18.4096L17.2047 19.2617L17.2048 19.2617L17.1116 18.4096ZM18.4347 17.0853L17.5825 16.9939L17.5825 16.9939L18.4347 17.0853ZM18.4347 2.91458L17.5825 3.00598L17.5825 3.00606L18.4347 2.91458ZM17.1116 1.59035L17.2047 0.738282L17.2047 0.738282L17.1116 1.59035ZM2.88839 1.59035L2.79524 0.738282L2.79524 0.738282L2.88839 1.59035ZM1.56522 2.91458L2.41747 3.00606L2.41747 3.00605L1.56522 2.91458ZM7.16077 12.9275L8.00927 12.8061L8.00927 12.8061L7.16077 12.9275ZM8.90002 14.0151L9.18733 14.8227L9.18734 14.8227L8.90002 14.0151ZM13.8112 10.7265L13.1359 10.1986L13.1359 10.1986L13.8112 10.7265ZM13.8113 9.27309L14.4866 8.74525L14.4866 8.74525L13.8113 9.27309ZM8.9001 5.98451L8.61279 6.79207L8.6128 6.79207L8.9001 5.98451ZM7.16087 7.07204L6.31237 6.9506L6.31237 6.95062L7.16087 7.07204ZM0.712974 17.1768C0.830796 18.2746 1.70007 19.1419 2.79522 19.2617L2.98157 17.5576C2.68457 17.5251 2.4491 17.2885 2.41747 16.9939L0.712974 17.1768ZM2.79525 19.2617C5.03182 19.5062 7.48472 19.8571 9.99999 19.8571V18.1429C7.60672 18.1429 5.29438 17.8104 2.98153 17.5576L2.79525 19.2617ZM9.99999 19.8571C12.5153 19.8571 14.9682 19.5062 17.2047 19.2617L17.0184 17.5576C14.7056 17.8104 12.3933 18.1429 9.99999 18.1429V19.8571ZM17.2048 19.2617C18.2999 19.1419 19.1692 18.2746 19.287 17.1767L17.5825 16.9939C17.5509 17.2885 17.3154 17.5251 17.0184 17.5576L17.2048 19.2617ZM19.287 17.1768C19.5268 14.9427 19.8571 12.5044 19.8571 9.99999H18.1429C18.1429 12.3859 17.8292 14.6952 17.5825 16.9939L19.287 17.1768ZM19.8571 9.99999C19.8571 7.49557 19.5268 5.05724 19.287 2.82309L17.5825 3.00606C17.8292 5.30471 18.1429 7.61405 18.1429 9.99999H19.8571ZM19.287 2.82318C19.1692 1.72531 18.2998 0.858012 17.2047 0.738282L17.0184 2.44241C17.3155 2.47489 17.5509 2.71141 17.5825 3.00598L19.287 2.82318ZM17.2047 0.738282C14.9682 0.49377 12.5153 0.142857 9.99999 0.142857V1.85714C12.3933 1.85714 14.7057 2.18957 17.0184 2.44241L17.2047 0.738282ZM9.99999 0.142857C7.48471 0.142857 5.03185 0.49377 2.79524 0.738282L2.98154 2.44241C5.29435 2.18957 7.60672 1.85714 9.99999 1.85714V0.142857ZM2.79524 0.738282C1.70011 0.858014 0.830799 1.72532 0.712974 2.82311L2.41747 3.00605C2.44909 2.7114 2.68454 2.47489 2.98155 2.44241L2.79524 0.738282ZM0.712975 2.8231C0.473165 5.05726 0.142857 7.49557 0.142857 9.99999H1.85714C1.85714 7.61404 2.17074 5.30469 2.41747 3.00606L0.712975 2.8231ZM0.142857 9.99999C0.142857 12.5044 0.473165 14.9427 0.712975 17.1768L2.41747 16.9939C2.17074 14.6952 1.85714 12.3859 1.85714 9.99999H0.142857ZM6.0296 9.99981C6.0296 10.8832 6.17791 12.1097 6.31226 13.0489L8.00927 12.8061C7.87486 11.8665 7.74389 10.7483 7.74389 9.99981H6.0296ZM6.31226 13.0489C6.50305 14.3826 7.84723 15.2995 9.18733 14.8227L8.6127 13.2076C8.36351 13.2962 8.05736 13.1423 8.00927 12.8061L6.31226 13.0489ZM9.18734 14.8227C11.188 14.1108 13.1288 12.9913 14.4865 11.2544L13.1359 10.1986C12.0454 11.5937 10.4284 12.5616 8.61269 13.2076L9.18734 14.8227ZM14.4865 11.2544C15.0634 10.5163 15.0635 9.48332 14.4866 8.74525L13.1359 9.80093C13.228 9.91868 13.228 10.0809 13.1359 10.1986L14.4865 11.2544ZM14.4866 8.74525C13.129 7.00823 11.1881 5.88873 9.18741 5.17695L8.6128 6.79207C10.4285 7.43804 12.0455 8.40582 13.1359 9.80093L14.4866 8.74525ZM9.18741 5.17695C7.84736 4.70019 6.50325 5.61697 6.31237 6.9506L8.00937 7.19348C8.05748 6.85729 8.36362 6.70341 8.61279 6.79207L9.18741 5.17695ZM6.31237 6.95062C6.17797 7.88984 6.0296 9.11642 6.0296 9.99981H7.74389C7.74389 9.25128 7.87491 8.13308 8.00937 7.19346L6.31237 6.95062Z"
                                            fill="currentColor"/>
                                    </svg>

                                </div>
                                <span>@lang('courses.Upcoming Courses') </span>
                            </div>

                            <i class="fa fa-chevron-down text-black"
                               style="font-size:14px;color: var(--system_secendory_color);"></i>
                        </a>
                        <ul class="collapse chat-menu-ul  {{$upcoming_course_menu?'show':''}}"
                            id="collapseUpcomingCourse">
                            <li>
                                <a class="chat-submenu {{ routeIs('upcoming_courses.my_following')  ? 'active' : '' }}"
                                   href="{{route('upcoming_courses.my_following')}}">{{ __('courses.Following') }}</a>
                            </li>

                            <li>
                                <a class="chat-submenu {{ routeIs('upcoming_courses.my_booking')  ? 'active' : '' }}"
                                   href="{{route('upcoming_courses.my_booking')}}">{{ __('courses.Prebooking') }}</a>
                            </li>

                        </ul>
                    </li>
                @endif

                @if(isModuleActive('Membership'))
                    <li>
                        <a href="{{route('membership.myMembership')}}"
                           class="  d-flex align-items-center {{ routeIs('membership.myMembership')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="20" height="19" viewBox="0 0 20 19" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M1.30221 4.39332C1.32703 4.1613 1.61527 4.10442 1.74802 4.29632L3.97125 7.51024C4.58579 8.39862 5.92339 8.31916 6.42844 7.36427L9.69842 1.18166C9.75753 1.06991 9.87358 1 10 1C10.1264 1 10.2425 1.06991 10.3016 1.18166L13.5716 7.36427C14.0766 8.31916 15.4143 8.39862 16.0287 7.51023L18.2519 4.29632C18.3847 4.10442 18.673 4.1613 18.6977 4.39332C18.8616 5.92477 19 7.49705 19 9.1C19 10.7029 18.8616 12.2752 18.6977 13.8066C18.4758 15.8812 16.8073 17.5498 14.7337 17.7809C13.1936 17.9525 11.6123 18.1 10 18.1C8.38773 18.1 6.80638 17.9525 5.26623 17.7809C3.19269 17.5498 1.52416 15.8812 1.30221 13.8066C1.13836 12.2752 1 10.7029 1 9.1C1 7.49705 1.13836 5.92477 1.30221 4.39332Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linejoin="round"/>
                                </svg>

                            </div>
                            <span>{{__('membership.Membership')}}</span>
                        </a>
                    </li>
                @endif
                @if(isModuleActive('Appointment'))

                    <li>
                        <a href="{{route('myAppointment')}}"
                           class=" d-flex align-items-center {{ routeIs('myAppointment')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M7.41469 1C7.41469 0.526613 7.03093 0.142857 6.55755 0.142857C6.08416 0.142857 5.7004 0.526613 5.7004 1H7.41469ZM5.7004 4.65645C5.7004 5.12984 6.08416 5.51359 6.55755 5.51359C7.03093 5.51359 7.41469 5.12984 7.41469 4.65645H5.7004ZM13.8751 1C13.8751 0.526613 13.4913 0.142857 13.0179 0.142857C12.5445 0.142857 12.1608 0.526613 12.1608 1H13.8751ZM12.1608 4.65645C12.1608 5.12984 12.5445 5.51359 13.0179 5.51359C13.4913 5.51359 13.8751 5.12984 13.8751 4.65645H12.1608ZM1.28481 15.076L0.433003 15.1714L0.433005 15.1715L1.28481 15.076ZM5.28517 18.8947L5.24392 19.7509L5.24398 19.7509L5.28517 18.8947ZM14.2999 18.8947L14.341 19.7509L14.3411 19.7509L14.2999 18.8947ZM18.3002 15.076L17.4484 14.9805L17.4484 14.9805L18.3002 15.076ZM18.3002 6.50656L17.4484 6.60202L17.4484 6.60208L18.3002 6.50656ZM14.2999 2.68779L14.2586 3.54394L14.2586 3.54395L14.2999 2.68779ZM5.28517 2.68779L5.3264 3.54395L5.3264 3.54394L5.28517 2.68779ZM1.28481 6.50656L0.433004 6.41108L0.433004 6.41109L1.28481 6.50656ZM5.47244 7.77394C4.99905 7.77394 4.6153 8.1577 4.6153 8.63108C4.6153 9.10447 4.99905 9.48823 5.47244 9.48823V7.77394ZM6.19244 9.48823C6.66583 9.48823 7.04959 9.10447 7.04959 8.63108C7.04959 8.1577 6.66583 7.77394 6.19244 7.77394V9.48823ZM5.47244 12.094C4.99905 12.094 4.6153 12.4777 4.6153 12.9511C4.6153 13.4245 4.99905 13.8083 5.47244 13.8083V12.094ZM6.19244 13.8083C6.66583 13.8083 7.04959 13.4245 7.04959 12.9511C7.04959 12.4777 6.66583 12.094 6.19244 12.094V13.8083ZM9.43247 7.77394C8.95908 7.77394 8.57533 8.1577 8.57533 8.63108C8.57533 9.10447 8.95908 9.48823 9.43247 9.48823V7.77394ZM10.1525 9.48823C10.6259 9.48823 11.0096 9.10447 11.0096 8.63108C11.0096 8.1577 10.6259 7.77394 10.1525 7.77394V9.48823ZM13.3925 7.77394C12.9191 7.77394 12.5354 8.1577 12.5354 8.63108C12.5354 9.10447 12.9191 9.48823 13.3925 9.48823V7.77394ZM14.1125 9.48823C14.5859 9.48823 14.9697 9.10447 14.9697 8.63108C14.9697 8.1577 14.5859 7.77394 14.1125 7.77394V9.48823ZM9.43247 12.094C8.95908 12.094 8.57533 12.4777 8.57533 12.9511C8.57533 13.4245 8.95908 13.8083 9.43247 13.8083V12.094ZM10.1525 13.8083C10.6259 13.8083 11.0096 13.4245 11.0096 12.9511C11.0096 12.4777 10.6259 12.094 10.1525 12.094V13.8083ZM5.7004 1V4.65645H7.41469V1H5.7004ZM12.1608 1V4.65645H13.8751V1H12.1608ZM0.433005 15.1715C0.710192 17.6442 2.72254 19.6294 5.24392 19.7509L5.32641 18.0386C3.6812 17.9593 2.3241 16.6529 2.13662 14.9805L0.433005 15.1715ZM5.24398 19.7509C6.6981 19.8208 8.1828 19.8571 9.79252 19.8571V18.1429C8.20933 18.1429 6.75211 18.1072 5.32635 18.0386L5.24398 19.7509ZM9.79252 19.8571C11.4022 19.8571 12.8869 19.8208 14.341 19.7509L14.2587 18.0386C12.8329 18.1072 11.3757 18.1429 9.79252 18.1429V19.8571ZM14.3411 19.7509C16.8624 19.6294 18.8749 17.6442 19.152 15.1714L17.4484 14.9805C17.261 16.6529 15.9038 17.9593 14.2586 18.0386L14.3411 19.7509ZM19.152 15.1715C19.3097 13.7652 19.4422 12.2969 19.4422 10.7912H17.7279C17.7279 12.2012 17.6038 13.595 17.4484 14.9805L19.152 15.1715ZM19.4422 10.7912C19.4422 9.28558 19.3097 7.81732 19.152 6.41104L17.4484 6.60208C17.6038 7.98747 17.7279 9.38131 17.7279 10.7912H19.4422ZM19.152 6.4111C18.8749 3.93818 16.8624 1.95307 14.3411 1.83164L14.2586 3.54395C15.9038 3.62317 17.261 4.92949 17.4484 6.60202L19.152 6.4111ZM14.3411 1.83164C12.887 1.76161 11.4023 1.72526 9.79252 1.72526V3.43954C11.3757 3.43954 12.8329 3.47528 14.2586 3.54394L14.3411 1.83164ZM9.79252 1.72526C8.18278 1.72526 6.69807 1.76161 5.24393 1.83164L5.3264 3.54394C6.75214 3.47528 8.20934 3.43954 9.79252 3.43954V1.72526ZM5.24394 1.83164C2.72255 1.95307 0.710189 3.9382 0.433004 6.41108L2.13662 6.60204C2.3241 4.92947 3.68119 3.62317 5.3264 3.54395L5.24394 1.83164ZM0.433004 6.41109C0.275389 7.8173 0.142857 9.28557 0.142857 10.7912H1.85714C1.85714 9.38132 1.98133 7.98749 2.13662 6.60204L0.433004 6.41109ZM0.142857 10.7912C0.142857 12.2969 0.275389 13.7652 0.433003 15.1714L2.13662 14.9805C1.98133 13.595 1.85714 12.2011 1.85714 10.7912H0.142857ZM5.47244 9.48823H6.19244V7.77394H5.47244V9.48823ZM5.47244 13.8083H6.19244V12.094H5.47244V13.8083ZM9.43247 9.48823H10.1525V7.77394H9.43247V9.48823ZM13.3925 9.48823H14.1125V7.77394H13.3925V9.48823ZM9.43247 13.8083H10.1525V12.094H9.43247V13.8083Z"
                                        fill="currentColor"/>
                                </svg>

                            </div>
                            <span>{{__('appointment.My Appointment')}}</span>
                        </a>
                    </li>

                    <li>
                        <a href="{{route('myWishlists')}}"
                           class=" d-flex align-items-center {{ routeIs('myWishlists')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="20" height="19" viewBox="0 0 20 19" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M10 3.62694C5.6516 -1.70847 1.06041 2.08254 1 6.16923C1 12.2531 8.27931 17.2468 10 17.2468C11.7207 17.2468 19 12.2531 19 6.16923C18.9396 2.08254 14.3484 -1.70847 10 3.62694Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                </svg>

                            </div>
                            <span>{{__('appointment.My WishList')}}</span>
                        </a>
                    </li>

                @endif
                @if(isModuleActive('ELibrary'))

                    <li>
                        <a href="{{route('e-library.my-e_library')}}"
                           class=" d-flex align-items-center {{ routeIs('e-library.my-e_library')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="20" height="21" viewBox="0 0 20 21" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M5.88533 18.4476V1.6979C5.88533 1.31246 5.57287 1 5.18743 1H1.6979C1.31246 1 1 1.31246 1 1.6979V18.4476C1 18.8331 1.31246 19.1455 1.6979 19.1455H5.18743C5.57287 19.1455 5.88533 18.8331 5.88533 18.4476ZM5.88533 18.4476C5.88533 18.8331 6.19779 19.1455 6.58324 19.1455H10.0728C10.4582 19.1455 10.7707 18.8331 10.7707 18.4476V4.48952C10.7707 4.10408 10.4582 3.79162 10.0728 3.79162H6.58324C6.19779 3.79162 5.88533 4.10408 5.88533 4.48952L5.88533 18.4476ZM1 14.2602H5.88533M5.88533 12.8644H10.7707M14.2602 15.656L18.2801 14.651M12.0358 4.08721L14.7439 3.4095C15.1178 3.31592 15.4968 3.54318 15.5904 3.91709L18.979 17.4576C19.0725 17.8315 18.8453 18.2105 18.4714 18.3041L15.7633 18.9818C15.3893 19.0754 15.0104 18.8481 14.9168 18.4742L11.5282 4.93367C11.4346 4.55976 11.6619 4.18079 12.0358 4.08721Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                </svg>

                            </div>
                            <span>{{__('elibrary.E-Library')}}</span>
                        </a>
                    </li>
                @endif
                @if(isModuleActive('MyClass'))

                    <li>
                        <a href="{{route('myclass')}}"
                           class=" d-flex align-items-center {{ routeIs('myclass')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="20" height="16" viewBox="0 0 20 16" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M2.79996 10.6113L2.18745 2.43502C2.12933 1.65917 2.7892 1 3.62395 1H16.3759C17.2107 1 17.8706 1.65917 17.8124 2.43502L17.2 10.6113M1 11.7194C1 11.0422 1.58742 10.5094 2.26275 10.5591C3.70436 10.665 6.34478 10.81 10 10.81C13.6552 10.81 16.2957 10.665 17.7373 10.5591C18.4126 10.5094 19 11.0422 19 11.7194C19 13.4561 17.6936 14.9002 15.9592 14.9884C14.4732 15.064 12.4679 15.1299 10 15.1299C7.53213 15.1299 5.52686 15.064 4.0408 14.9884C2.30631 14.9002 1 13.4561 1 11.7194Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                </svg>

                            </div>
                            <span>{{__('class.My Class')}}</span>
                        </a>
                    </li>
                @endif
                @if(isModuleActive('CPD'))

                    <li>
                        <a href="{{route('myCpd')}}"
                           class=" d-flex align-items-center {{ routeIs('myCpd')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="22" height="22" viewBox="0 0 22 22" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M3.92885 3.92891L4.51809 4.51816M10.9999 1V1.83333M20.9999 11H20.1667M1.83333 11H1M18.071 3.92891L17.4817 4.51816M12.8499 21H9.15M15.6332 8.64432C16.1127 9.47136 16.362 10.4117 16.3555 11.3676C16.3513 12.3594 16.0707 13.3303 15.5451 14.1712C15.3696 14.4521 15.2051 14.6982 15.0539 14.9247C14.509 15.7405 14.1352 16.3 14.0308 17.3H7.97042C7.86792 16.2674 7.48885 15.7063 6.89798 14.8319C6.77845 14.655 6.65024 14.4652 6.5139 14.2562C5.99169 13.4554 5.69334 12.5295 5.64982 11.5744C5.6063 10.6195 5.8192 9.67021 6.26642 8.82526C6.71363 7.98034 7.37886 7.2705 8.19304 6.76947C9.00721 6.26843 9.94067 5.99446 10.8965 5.976C11.8523 5.95754 12.7956 6.19525 13.6286 6.66446C14.4615 7.13368 15.1536 7.8173 15.6332 8.64432Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                </svg>

                            </div>
                            <span>{{__('cpd.My CPD')}}</span>
                        </a>
                    </li>
                @endif
                @if (isModuleActive('Org'))
                    <li>
                        <a href="{{route('myReports')}}"
                           class=" d-flex align-items-center {{ routeIs('myReports')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M5.60767 5.40881H8.39076M5.96766 10.0004H8.75074M5.96766 14.5922H8.75074M17.8237 8.33563H12.289C11.2316 2.32847 13.9014 0.956056 15.4613 1.00106C18.7012 1.50503 18.4387 6.10076 17.8237 8.33563ZM11.4398 18.2805C15.4123 13.6479 8.55546 2.94074 14.929 1.00109H4.48921C-1.61813 2.94074 4.70517 14.0036 1 17.9131C1 17.9131 2.25958 19 6.12616 19C9.99274 19 11.4398 18.2805 11.4398 18.2805Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                </svg>

                            </div>
                            <span>{{__('common.Reports')}}</span>
                        </a>
                    </li>
                @endif
                @if(isModuleActive('OrgSubscription'))
                    <li>
                        <a href="{{route('orgSubscriptionCourses')}}"
                           class=" d-flex align-items-center {{ routeIs('orgSubscriptionCourses')  ? 'active' : '' }}">
                            <span>{{__('org-subscription.My Plan')}}</span>
                        </a>
                    </li>
                @endif

                @if(isModuleActive('Homework'))
                    <li>
                        <a href="{{route('myHomework')}}"
                           class=" d-flex align-items-center {{ routeIs('myHomework')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="17" height="20" viewBox="0 0 17 20" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M2.5232 3.55396L2.41868 2.70322L2.41868 2.70322L2.5232 3.55396ZM1.22478 4.90011L2.07981 4.9603L2.07981 4.96029L1.22478 4.90011ZM1.22478 17.4366L0.369753 17.4968L0.369753 17.4968L1.22478 17.4366ZM2.52611 18.7576L2.45437 19.6118L2.45453 19.6118L2.52611 18.7576ZM13.7639 18.7576L13.8354 19.6118L13.8356 19.6118L13.7639 18.7576ZM15.0652 17.4366L15.9202 17.4968L15.9202 17.4968L15.0652 17.4366ZM15.0652 4.90011L15.9202 4.83994L15.9202 4.83991L15.0652 4.90011ZM13.7668 3.55396L13.8713 2.70322L13.8713 2.70322L13.7668 3.55396ZM3.93464 2.51199C3.41069 2.57725 2.92262 2.64131 2.41868 2.70322L2.62771 4.40471C3.12332 4.34383 3.6472 4.27533 4.14653 4.21313L3.93464 2.51199ZM2.41868 2.70322C1.33046 2.83692 0.449059 3.71317 0.369752 4.83992L2.07981 4.96029C2.09921 4.68466 2.32057 4.44245 2.62772 4.40471L2.41868 2.70322ZM0.369753 4.83991C0.0672253 9.13724 0.0672253 13.1996 0.369753 17.4968L2.07981 17.3764C1.78292 13.1593 1.78292 9.17747 2.07981 4.9603L0.369753 4.83991ZM0.369753 17.4968C0.44869 18.618 1.33122 19.5174 2.45437 19.6118L2.59785 17.9035C2.32007 17.8802 2.09961 17.6577 2.07981 17.3764L0.369753 17.4968ZM2.45453 19.6118C6.35806 19.9389 9.93184 19.9389 13.8354 19.6118L13.6923 17.9035C9.88396 18.2226 6.40595 18.2226 2.59769 17.9035L2.45453 19.6118ZM13.8356 19.6118C14.9587 19.5174 15.8413 18.618 15.9202 17.4968L14.2102 17.3764C14.1904 17.6577 13.9699 17.8802 13.6921 17.9035L13.8356 19.6118ZM15.9202 17.4968C16.2226 13.1996 16.2226 9.13725 15.9202 4.83994L14.2102 4.96027C14.5069 9.17746 14.5069 13.1594 14.2102 17.3765L15.9202 17.4968ZM15.9202 4.83991C15.8409 3.71311 14.9593 2.83692 13.8713 2.70322L13.6622 4.40471C13.9693 4.44244 14.1908 4.68471 14.2102 4.96031L15.9202 4.83991ZM13.8713 2.70322C13.3675 2.64133 12.879 2.57723 12.3553 2.51199L12.1434 4.21313C12.6428 4.27535 13.1665 4.34381 13.6623 4.40471L13.8713 2.70322ZM6.18733 1.85714H10.1018V0.142857H6.18733V1.85714ZM10.1018 1.85714C10.822 1.85714 11.4058 2.44096 11.4058 3.16114H13.1201C13.1201 1.49419 11.7688 0.142857 10.1018 0.142857V1.85714ZM11.4058 3.16114V3.1626H13.1201V3.16114H11.4058ZM11.4058 3.1626C11.4058 3.88278 10.822 4.4666 10.1018 4.4666V6.18089C11.7688 6.18089 13.1201 4.82955 13.1201 3.1626H11.4058ZM10.1018 4.4666H6.18733V6.18089H10.1018V4.4666ZM6.18733 4.4666C5.46715 4.4666 4.88333 3.88278 4.88333 3.1626H3.16904C3.16904 4.82955 4.52037 6.18089 6.18733 6.18089V4.4666ZM4.88333 3.1626V3.16114H3.16904V3.1626H4.88333ZM4.88333 3.16114C4.88333 2.44096 5.46715 1.85714 6.18733 1.85714V0.142857C4.52037 0.142857 3.16904 1.49419 3.16904 3.16114H4.88333Z"
                                        fill="currentColor"/>
                                </svg>

                            </div>
                            <span>{{_trans('homework.Homework')}}</span></a>
                    </li>
                @endif

                @if(isModuleActive('Survey'))
                    <li>
                        <a href="{{route('survey.student_survey')}}"
                           class=" d-flex align-items-center  {{ routeIs('survey.student_survey')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M21.1058 22.2306C21.9141 20.8972 22.4272 19.588 22.4272 17.6059C22.4272 13.6421 18.5925 12.6449 15.8206 12.357V8.02646C15.8206 6.74941 14.7854 5.71415 13.5083 5.71415C12.2313 5.71415 11.196 6.74941 11.196 8.02646V14.9634L10.4689 15.3789C8.506 16.5005 8.14696 19.1815 9.74553 20.7801L11.196 22.2306M18.6559 4.85714C18.8749 4.47892 19 4.03981 19 3.57143C19 2.15126 17.8487 1 16.4286 1H14.7143C13.9892 1 13.3342 1.30013 12.8667 1.78295M7.85714 13C7.85714 11.5798 6.70588 10.4286 5.28571 10.4286H3.57143C2.15126 10.4286 1 11.5798 1 13C1 14.4202 2.15126 15.5714 3.57143 15.5714H5.28571M3.57143 1H5.28571C6.70587 1 7.85714 2.15127 7.85714 3.57143C7.85714 4.99159 6.70587 6.14286 5.28571 6.14286H3.57143C2.15127 6.14286 1 4.99159 1 3.57143C1 2.15127 2.15127 1 3.57143 1Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                </svg>

                            </div>
                            <span>{{__('survey.Survey')}}</span>
                        </a>
                    </li>
                @endif

                @if(isModuleActive('Chat'))
                    <li>
                        <a class=" d-flex justify-content-between align-items-center  {{ routeIs('chat.index')  ? 'active' : '' }}"
                           data-bs-toggle="collapse" href="#collapseExample" role="button" aria-expanded="false"
                           aria-controls="collapseExample">
                            <div class="d-flex align-items-center ">
                                <div class="menu_icon">
                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M3.07692 14.32L1 14.8462L2.38462 10.6923V2.38462C2.38462 2.01739 2.5305 1.66521 2.79016 1.40554C3.04983 1.14588 3.402 1 3.76923 1H14.8462C15.2134 1 15.5656 1.14588 15.8252 1.40554C16.0848 1.66521 16.2308 2.01739 16.2308 2.38462V4.46154M14.1538 17.6154L19 19L18.3077 14.8462V9.30769C18.3077 8.94047 18.1618 8.58829 17.9021 8.32862C17.6425 8.06896 17.2903 7.92308 16.9231 7.92308H7.92308C7.55585 7.92308 7.20367 8.06896 6.944 8.32862C6.68434 8.58829 6.53846 8.94047 6.53846 9.30769V16.2308C6.53846 16.598 6.68434 16.9502 6.944 17.2098C7.20367 17.4694 7.55585 17.6154 7.92308 17.6154H14.1538Z"
                                            stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"
                                            stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <span>@lang('chat.chat') </span>
                            </div>
                            <i class="fa fa-chevron-down "></i>
                        </a>
                        <ul class="collapse chat-menu-ul" id="collapseExample">
                            <li>
                                <a class="chat-submenu" href="{{ route('chat.index') }}">{{ __('chat.chat_box') }}</a>
                            </li>

                            <li>
                                <a class="chat-submenu"
                                   href="{{ route('chat.invitation') }}">{{ __('chat.invitation') }}</a>
                            </li>

                            <li>
                                <a class="chat-submenu"
                                   href="{{ route('chat.blocked.users') }}">{{ __('chat.blocked_user') }}</a>
                            </li>
                        </ul>
                    </li>
                @endif
                @if (isModuleActive('Installment'))
                    <li>
                        <a href="{{route('installment.student_installment.list')}}"
                           class=" d-flex align-items-center {{ routeIs('installment.student_installment.list')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M5.60767 5.40881H8.39076M5.96766 10.0004H8.75074M5.96766 14.5922H8.75074M17.8237 8.33563H12.289C11.2316 2.32847 13.9014 0.956056 15.4613 1.00106C18.7012 1.50503 18.4387 6.10076 17.8237 8.33563ZM11.4398 18.2805C15.4123 13.6479 8.55546 2.94074 14.929 1.00109H4.48921C-1.61813 2.94074 4.70517 14.0036 1 17.9131C1 17.9131 2.25958 19 6.12616 19C9.99274 19 11.4398 18.2805 11.4398 18.2805Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                </svg>

                            </div>
                            <span>{{_trans('installment.Installment')}}</span>
                        </a>
                    </li>
                @endif
                @if (isModuleActive('Cashback'))
                    <li>
                        <a href="{{validRouteUrl('cashback.my-cashback')}}"
                           class=" d-flex align-items-center {{ routeIs('cashback.my-cashback')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path d="M2 11V9C2 5.5 4 4 7 4H17C20 4 22 5.5 22 9V15C22 18.5 20 20 17 20H12"
                                          stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10"
                                          stroke-linecap="round" stroke-linejoin="round"/>
                                    <path
                                        d="M12 14.5C13.3807 14.5 14.5 13.3807 14.5 12C14.5 10.6193 13.3807 9.5 12 9.5C10.6193 9.5 9.5 10.6193 9.5 12C9.5 13.3807 10.6193 14.5 12 14.5Z"
                                        stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10"
                                        stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M18.5 9.5V14.5" stroke="currentColor" stroke-width="1.5"
                                          stroke-miterlimit="10"
                                          stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M2 15.5H7.34003C7.98003 15.5 8.5 16.02 8.5 16.66V17.94"
                                          stroke="currentColor"
                                          stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round"
                                          stroke-linejoin="round"/>
                                    <path d="M3.21997 14.28L2 15.5L3.21997 16.72" stroke="currentColor"
                                          stroke-width="1.5"
                                          stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M8.5 20.7801H3.15997C2.51997 20.7801 2 20.2601 2 19.6201V18.3401"
                                          stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10"
                                          stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M7.28125 22.0003L8.50122 20.7803L7.28125 19.5603" stroke="currentColor"
                                          stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round"
                                          stroke-linejoin="round"/>
                                </svg>

                            </div>
                            <span>{{_trans('cashback.Cashback')}}</span>
                        </a>
                    </li>
                @endif

                @if(isModuleActive('BundleSubscription'))
                    <li>
                        <a href="{{route('myBundle')}}"
                           class=" d-flex align-items-center {{ routeIs('myBundle')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="16" height="20" viewBox="0 0 16 20" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M11.3585 12.7724C11.3585 13.5049 11.0675 14.2073 10.5496 14.7253C10.0316 15.2432 9.32915 15.5342 8.59668 15.5342M6.73247 1.07621C6.64898 1.02633 6.55354 1 6.45629 1C6.35904 1 6.2636 1.02633 6.18011 1.07621C6.11124 1.13077 6.06477 1.2087 6.0495 1.29522C6.03424 1.38175 6.05122 1.47087 6.09726 1.54571C7.79576 4.48702 8.15479 8.49162 5.83489 10.701C4.94231 9.95097 4.23369 9.00615 3.76354 7.93926C2.90563 8.41574 2.19464 9.11813 1.70776 9.97017C1.22087 10.8222 0.976701 11.7914 1.00175 12.7724C1.03677 13.6372 1.24442 14.4863 1.61248 15.2697C1.98054 16.0531 2.50158 16.7549 3.14492 17.3339C3.78827 17.9129 4.54093 18.3574 5.35862 18.6412C6.17631 18.925 7.0425 19.0424 7.90623 18.9864C12.3527 18.9864 14.6588 16.2246 14.8107 12.7724C14.9902 8.62971 12.0489 3.5342 6.73247 1.07621Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                </svg>

                            </div>
                            <span>{{__('bundleSubscription.Bundle Course')}}</span>
                        </a>
                    </li>
                @endif

                @if (permissionCheck('myCertificate'))
                    <li>
                        <a href="{{route('myCertificate')}}"
                           class=" d-flex align-items-center  {{ routeIs('myCertificate')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="17" height="20" viewBox="0 0 17 20" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M15.4307 18.2183C15.3801 18.9256 14.5305 19.2561 14.0153 18.7691L9.39537 14.4015C8.80981 13.848 7.89387 13.848 7.30831 14.4015L2.68845 18.7691C2.17324 19.2561 1.32357 18.9256 1.27306 18.2183C0.929826 13.4131 0.91535 8.59416 1.20047 3.78824C1.29405 2.21097 2.61479 1 4.19482 1H12.5089C14.0889 1 15.4096 2.21097 15.5031 3.78824C15.7884 8.59416 15.7738 13.4131 15.4307 18.2183Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                </svg>

                            </div>
                            <span>{{__('certificate.Certificate')}}</span>
                        </a>
                    </li>
                @endif
                @if (isModuleActive('Assignment'))

                    <li>
                        <a href="{{route('myAssignment')}}"
                           class=" d-flex align-items-center  {{ routeIs('myAssignment')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="20" height="21" viewBox="0 0 20 21" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M1 19.6737C4.58887 17.871 9.24732 13.9319 10.684 11.2367M18.8791 1.10477C17.8117 0.965076 16.735 0.965076 15.6677 1.10477L12.8003 6.61649L11.0354 2.64909C4.64117 6.44143 0.526496 12.1162 5.14725 17.7023C9.76801 23.2883 20.2397 15.5877 18.8791 1.10477Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                </svg>

                            </div>
                            <span>{{__('assignment.Assignment')}}</span>
                        </a>
                    </li>
                @endif
                @if (permissionCheck('myInvoice'))
                    <li>
                        <a href="{{validRouteUrl('myInvoice')}}"
                           class=" d-flex align-items-center  {{ routeIs('myInvoice')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M14.9777 10H5.02544M14.8594 5.17445H5.14417M14.8594 14.8255H5.14417M1 17.6154V2.38462C1 1.61991 1.61991 1 2.38462 1H17.6154C18.3801 1 19 1.61991 19 2.38462V17.6154C19 18.3801 18.3801 19 17.6154 19H2.38462C1.61991 19 1 18.3801 1 17.6154Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                </svg>

                            </div>
                            <span>{{__('invoice.My Invoice')}}</span>
                        </a>
                    </li>
                @endif
                @if (permissionCheck('myPurchases'))
                    <li>
                        <a href="{{route('myPurchases')}}"
                           class=" d-flex align-items-center  {{ routeIs('myPurchases')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M5.60767 5.40881H8.39076M5.96766 10.0004H8.75074M5.96766 14.5922H8.75074M17.8237 8.33563H12.289C11.2316 2.32847 13.9014 0.956056 15.4613 1.00106C18.7012 1.50503 18.4387 6.10076 17.8237 8.33563ZM11.4398 18.2805C15.4123 13.6479 8.55546 2.94074 14.929 1.00109H4.48921C-1.61813 2.94074 4.70517 14.0036 1 17.9131C1 17.9131 2.25958 19 6.12616 19C9.99274 19 11.4398 18.2805 11.4398 18.2805Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                </svg>

                            </div>
                            <span>{{__('common.Purchase History')}}</span>
                        </a>
                    </li>
                @endif
                @if (isModuleActive('Store') && permissionCheck('myRefundDispute'))
                    <li>
                        <a href="{{route('myRefundDispute')}}"
                           class=" d-flex align-items-center  {{ routeIs('myRefundDispute')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18.002"
                                     viewBox="0 0 18 18.002">
                                    <g transform="translate(-1.25 -1.254)">
                                        <path data-name="Path 4166"
                                              d="M14.436,20.068H6.064A4.558,4.558,0,0,1,1.25,15.253V11.065A4.518,4.518,0,0,1,5.31,6.309a5.391,5.391,0,0,1,.753-.059h8.372a4.764,4.764,0,0,1,.728.05,4.514,4.514,0,0,1,4.086,4.765v4.187A4.558,4.558,0,0,1,14.436,20.068ZM6.064,7.506a4.489,4.489,0,0,0-.586.042,3.286,3.286,0,0,0-2.972,3.517v4.187a3.336,3.336,0,0,0,3.558,3.559h8.372a3.336,3.336,0,0,0,3.558-3.559V11.065A3.288,3.288,0,0,0,14.989,7.54a3.2,3.2,0,0,0-.553-.034Z"
                                              transform="translate(0 -0.812)" fill="currentColor"></path>
                                        <path data-name="Path 4167"
                                              d="M6.069,6.746a.631.631,0,0,1-.511-.26.616.616,0,0,1-.05-.653,3.008,3.008,0,0,1,.6-.812l2.72-2.73a3.581,3.581,0,0,1,5.039,0l1.465,1.482a3.478,3.478,0,0,1,1.038,2.3.63.63,0,0,1-.209.5.623.623,0,0,1-.519.151,3.564,3.564,0,0,0-.527-.033H6.747a4.488,4.488,0,0,0-.586.042A.314.314,0,0,1,6.069,6.746Zm1.4-1.306h7.5a2.23,2.23,0,0,0-.519-.779L12.975,3.17a2.334,2.334,0,0,0-3.264,0Z"
                                              transform="translate(-0.681)" fill="currentColor"></path>
                                        <path data-name="Path 4168"
                                              d="M21.065,16.356H18.553a2.3,2.3,0,0,1,0-4.606h2.512a.628.628,0,1,1,0,1.256H18.553a1.047,1.047,0,0,0,0,2.094h2.512a.628.628,0,1,1,0,1.256Z"
                                              transform="translate(-2.443 -1.706)" fill="currentColor"></path>
                                    </g>
                                </svg>
                            </div>
                            <span>{{__('product.Store Refund & Dispute')}}</span>
                        </a>
                    </li>

                @endif



                @if (permissionCheck('enrollmentCancellation'))
                    <li>
                        <a href="{{route('enrollmentCancellation')}}"
                           class=" d-flex align-items-center  {{ routeIs('enrollmentCancellation')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="19" height="20" viewBox="0 0 19 20" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M1 5.15385H17.6154M5.84615 5.15385V4.46154C5.84615 3.54348 6.21085 2.66302 6.86001 2.01386C7.50917 1.3647 8.38964 1 9.30769 1C10.2257 1 11.1062 1.3647 11.7554 2.01386C12.4045 2.66302 12.7692 3.54348 12.7692 4.46154V5.15385M7.23077 9.30971V14.8503M11.3846 9.30971V14.8503M3.07692 5.15385H15.5385V17.6154C15.5385 17.9826 15.3925 18.3348 15.1329 18.5944C14.8733 18.8541 14.521 19 14.1538 19H4.46154C4.09431 19 3.74213 18.8541 3.48246 18.5944C3.22281 18.3348 3.07692 17.9826 3.07692 17.6154V5.15385Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                </svg>

                            </div>
                            <span>{{__('frontend.Refund & Cancellation')}}</span>
                        </a>
                    </li>
                @endif


                @if (permissionCheck('deposit') && showEcommerce())
                    <li>
                        <a href="{{route('deposit')}}"
                           class=" d-flex align-items-center {{ routeIs('deposit')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="18" height="20" viewBox="0 0 18 20" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M10.135 5.43111L11.467 2.40726C11.6359 2.02369 11.6947 1.55931 11.3152 1.38152C10.2292 0.872825 7.27737 0.872825 6.19143 1.38152C5.81189 1.55931 5.87067 2.02369 6.03963 2.40726L7.37159 5.43111C7.61934 5.9936 8.12469 6.29277 8.64649 6.32866C8.63192 6.3286 8.61735 6.32859 8.60275 6.32859C3.73699 6.32859 1 9.05163 1 13.8926C1 18.7335 3.73699 19 8.60275 19C13.4686 19 16.2054 18.7335 16.2054 13.8926C16.2054 9.12673 13.5528 6.41359 8.82768 6.33055C9.36086 6.30505 9.88213 6.00524 10.135 5.43111Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linejoin="round"/>
                                </svg>

                            </div>
                            <span>{{__('common.Deposit')}}</span>
                        </a>
                    </li>
                @endif
                @if (permissionCheck('student.gamification.reward') && showEcommerce() && Settings('gamification_status'))
                    <li>
                        <a href="{{route('student.gamification.reward')}}"
                           class=" d-flex align-items-center {{ routeIs('student.gamification.reward')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="18" height="20" viewBox="0 0 18 20" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M4.70495 18.8625L4.76695 18.0076L4.76694 18.0076L4.70495 18.8625ZM13.3792 18.8625L13.3172 18.0076L13.3172 18.0076L13.3792 18.8625ZM16.9653 15.2749L17.8196 15.3444L17.8196 15.3442L16.9653 15.2749ZM16.9653 9.56532L16.1109 9.63471V9.63471L16.9653 9.56532ZM13.3792 5.97769L13.3172 6.83258L13.3172 6.83258L13.3792 5.97769ZM4.70495 5.97769L4.76695 6.83258L4.76696 6.83258L4.70495 5.97769ZM1.11898 9.56532L1.97331 9.63471L1.97331 9.63471L1.11898 9.56532ZM1.11898 15.2749L0.264652 15.3443L0.264652 15.3443L1.11898 15.2749ZM9.04202 5.81295L8.31398 6.26534C8.47038 6.51703 8.74569 6.67009 9.04202 6.67009C9.33835 6.67009 9.61366 6.51703 9.77006 6.26534L9.04202 5.81295ZM11.3245 2.13965L12.0526 2.59204L12.0526 2.59204L11.3245 2.13965ZM15.5194 2.27772L14.7629 2.68065L14.7629 2.68067L15.5194 2.27772ZM14.4419 5.55281L14.0686 4.78124L14.0685 4.78125L14.4419 5.55281ZM13.1704 5.21584C12.7443 5.42203 12.566 5.93463 12.7722 6.36075C12.9784 6.78687 13.491 6.96515 13.9171 6.75895L13.1704 5.21584ZM6.75952 2.13965L6.03148 2.59204L6.03148 2.59204L6.75952 2.13965ZM2.56453 2.27772L3.32106 2.68066L3.32106 2.68065L2.56453 2.27772ZM3.64208 5.55281L3.26875 6.32438L3.26876 6.32438L3.64208 5.55281ZM4.16693 6.75897C4.59306 6.96515 5.10565 6.78685 5.31183 6.36072C5.51801 5.9346 5.33971 5.42201 4.91358 5.21582L4.16693 6.75897ZM4.64294 19.7174C5.95759 19.8128 7.40943 19.8571 9.04208 19.8571V18.1429C7.43922 18.1429 6.03019 18.0993 4.76695 18.0076L4.64294 19.7174ZM9.04208 19.8571C10.6747 19.8571 12.1266 19.8128 13.4412 19.7174L13.3172 18.0076C12.054 18.0993 10.645 18.1429 9.04208 18.1429V19.8571ZM13.4412 19.7174C15.7971 19.5466 17.6298 17.6794 17.8196 15.3444L16.1109 15.2055C15.988 16.7171 14.8105 17.8994 13.3172 18.0076L13.4412 19.7174ZM17.8196 15.3442C17.8969 14.3906 17.9412 13.4168 17.9412 12.42H16.227C16.227 13.3658 16.1849 14.2932 16.1109 15.2057L17.8196 15.3442ZM17.9412 12.42C17.9412 11.4234 17.8971 10.4496 17.8196 9.49592L16.1109 9.63471C16.185 10.5469 16.227 11.4742 16.227 12.42H17.9412ZM17.8196 9.49593C17.6299 7.1608 15.7971 5.29365 13.4412 5.12279L13.3172 6.83258C14.8106 6.94089 15.9882 8.12318 16.1109 9.63471L17.8196 9.49593ZM13.4412 5.12279C12.1266 5.02742 10.6747 4.98312 9.04208 4.98312V6.69741C10.645 6.69741 12.054 6.74095 13.3172 6.83258L13.4412 5.12279ZM9.04208 4.98312C7.40945 4.98312 5.9576 5.02742 4.64293 5.12279L4.76696 6.83258C6.03018 6.74095 7.4392 6.69741 9.04208 6.69741V4.98312ZM4.64295 5.12279C2.28705 5.29365 0.454306 7.16083 0.264652 9.49593L1.97331 9.63471C2.09608 8.12315 3.2736 6.94089 4.76695 6.83258L4.64295 5.12279ZM0.264652 9.49592C0.187194 10.4495 0.142857 11.4234 0.142857 12.42H1.85714C1.85714 11.4743 1.89921 10.547 1.97331 9.63471L0.264652 9.49592ZM0.142857 12.42C0.142857 13.4168 0.187194 14.3906 0.264652 15.3443L1.97331 15.2056C1.89921 14.2932 1.85714 13.3658 1.85714 12.42H0.142857ZM0.264652 15.3443C0.454306 17.6794 2.28704 19.5466 4.64296 19.7174L4.76694 18.0076C3.27361 17.8994 2.09608 16.7171 1.97331 15.2056L0.264652 15.3443ZM1 11.815H17.0841V10.1007H1V11.815ZM9.89922 19V5.84026H8.18493V19H9.89922ZM9.77006 6.26534L12.0526 2.59204L10.5965 1.68727L8.31398 5.36057L9.77006 6.26534ZM12.0526 2.59204C12.6857 1.57304 14.2002 1.62413 14.7629 2.68065L16.276 1.87479C15.0914 -0.349321 11.9259 -0.45225 10.5965 1.68727L12.0526 2.59204ZM14.7629 2.68067C15.1702 3.44537 14.8617 4.39747 14.0686 4.78124L14.8152 6.32439C16.4767 5.52049 17.1445 3.50534 16.276 1.87477L14.7629 2.68067ZM14.0685 4.78125L13.1704 5.21584L13.9171 6.75895L14.8152 6.32437L14.0685 4.78125ZM9.77006 5.36057L7.48756 1.68727L6.03148 2.59204L8.31398 6.26534L9.77006 5.36057ZM7.48756 1.68727C6.15812 -0.452245 2.99255 -0.349329 1.80799 1.87479L3.32106 2.68065C3.88375 1.62414 5.3983 1.57303 6.03148 2.59204L7.48756 1.68727ZM1.808 1.87479C0.93955 3.50534 1.60731 5.52048 3.26875 6.32438L4.01541 4.78124C3.22229 4.39748 2.91376 3.44537 3.32106 2.68066L1.808 1.87479ZM3.26876 6.32438L4.16693 6.75897L4.91358 5.21582L4.01541 4.78124L3.26876 6.32438Z"
                                        fill="currentColor"/>
                                </svg>

                            </div>
                            <span>{{__('setting.Reward Point')}}</span>
                        </a>
                    </li>
                @endif
                @if (permissionCheck('logged.in.devices'))
                    <li>
                        <a href="{{route('logged.in.devices')}}"
                           class=" d-flex align-items-center {{ routeIs('logged.in.devices')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="20" height="16" viewBox="0 0 20 16" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M2.79996 10.6113L2.18745 2.43502C2.12933 1.65917 2.7892 1 3.62395 1H16.3759C17.2107 1 17.8706 1.65917 17.8124 2.43502L17.2 10.6113M1 11.7194C1 11.0422 1.58742 10.5094 2.26275 10.5591C3.70436 10.665 6.34478 10.81 10 10.81C13.6552 10.81 16.2957 10.665 17.7373 10.5591C18.4126 10.5094 19 11.0422 19 11.7194C19 13.4561 17.6936 14.9002 15.9592 14.9884C14.4732 15.064 12.4679 15.1299 10 15.1299C7.53213 15.1299 5.52686 15.064 4.0408 14.9884C2.30631 14.9002 1 13.4561 1 11.7194Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                </svg>

                            </div>
                            <span>{{__('common.Logged In Devices')}}</span>
                        </a>
                    </li>
                @endif
                @if (permissionCheck('referral') && showEcommerce())
                    <li>
                        <a href="{{route('referral')}}"
                           class=" d-flex align-items-center {{ routeIs('referral')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M4.46143 6.53841C6.23372 6.53841 7.23064 5.54151 7.23064 3.76921C7.23064 1.99692 6.23372 1 4.46143 1C2.68914 1 1.69222 1.99692 1.69222 3.76921C1.69222 5.54151 2.68914 6.53841 4.46143 6.53841Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                    <path
                                        d="M15.5384 6.53841C17.3106 6.53841 18.3075 5.54151 18.3075 3.76921C18.3075 1.99692 17.3106 1 15.5384 1C13.7661 1 12.7692 1.99692 12.7692 3.76921C12.7692 5.54151 13.7661 6.53841 15.5384 6.53841Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                    <path
                                        d="M4.46153 19C1.00002 19 1 14.2923 1 10C3.76486 9.16692 5.27818 9.20091 7.92302 10C7.92302 14.2923 7.92305 19 4.46153 19Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                    <path
                                        d="M15.5383 9.30758C12.0768 9.30758 12.0768 14.1679 12.0768 18.4601C14.7807 19.1377 16.2961 19.1523 18.9999 18.4601C18.9999 14.1679 18.9999 9.30758 15.5383 9.30758Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                </svg>

                            </div>
                            <span>{{__('common.Referral')}}</span>
                        </a>
                    </li>
                @endif
                @if(isModuleActive('Subscription'))
                    @if(isSubscribe())
                        <li>
                            <a href="{{route('subscriptionCourses')}}"
                               class=" d-flex align-items-center {{ routeIs('subscriptionCourses')  ? 'active' : '' }}">
                                <div class="menu_icon">
                                    <svg width="16" height="20" viewBox="0 0 16 20" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M11.3585 12.7724C11.3585 13.5049 11.0675 14.2073 10.5496 14.7253C10.0316 15.2432 9.32915 15.5342 8.59668 15.5342M6.73247 1.07621C6.64898 1.02633 6.55354 1 6.45629 1C6.35904 1 6.2636 1.02633 6.18011 1.07621C6.11124 1.13077 6.06477 1.2087 6.0495 1.29522C6.03424 1.38175 6.05122 1.47087 6.09726 1.54571C7.79576 4.48702 8.15479 8.49162 5.83489 10.701C4.94231 9.95097 4.23369 9.00615 3.76354 7.93926C2.90563 8.41574 2.19464 9.11813 1.70776 9.97017C1.22087 10.8222 0.976701 11.7914 1.00175 12.7724C1.03677 13.6372 1.24442 14.4863 1.61248 15.2697C1.98054 16.0531 2.50158 16.7549 3.14492 17.3339C3.78827 17.9129 4.54093 18.3574 5.35862 18.6412C6.17631 18.925 7.0425 19.0424 7.90623 18.9864C12.3527 18.9864 14.6588 16.2246 14.8107 12.7724C14.9902 8.62971 12.0489 3.5342 6.73247 1.07621Z"
                                            stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"
                                            stroke-linejoin="round"/>
                                    </svg>

                                </div>
                                <span>{{__('subscription.Subscription')}}</span>
                            </a>
                        </li>
                    @endif
                @endif
                @if(isModuleActive('Affiliate') && hasAffiliateAccess() )
                    <li>
                        <a href="{{route('student.my_affiliate.index')}}"
                           class=" d-flex align-items-center {{ routeIs('student.my_affiliate.index')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="20" height="18" viewBox="0 0 20 18" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M15.8623 14.6171L15.6082 15.4357L15.6082 15.4357L15.8623 14.6171ZM3.04599 10.6387L2.79187 11.4573L2.79188 11.4573L3.04599 10.6387ZM3.04599 5.08379L2.79187 4.26518L2.79187 4.26518L3.04599 5.08379ZM15.8623 1.1053L16.1164 1.92391L16.1164 1.92391L15.8623 1.1053ZM16.7176 1.04435L16.9872 0.230732L16.9871 0.230704L16.7176 1.04435ZM16.7176 14.678L16.4479 13.8644L16.4478 13.8644L16.7176 14.678ZM3.26937 10.4649C2.80382 11.1816 2.53326 12.0353 2.53326 12.9496H4.24755C4.24755 12.3782 4.41572 11.8471 4.70696 11.3988L3.26937 10.4649ZM2.53326 12.9496C2.53326 15.5056 4.63332 17.5556 7.19646 17.5556V15.8413C5.55554 15.8413 4.24755 14.5345 4.24755 12.9496H2.53326ZM7.19646 17.5556C9.69852 17.5556 11.7584 15.6029 11.8561 13.1319L10.1431 13.0641C10.0826 14.5962 8.79753 15.8413 7.19646 15.8413V17.5556ZM16.1164 13.7985L3.3001 9.82004L2.79188 11.4573L15.6082 15.4357L16.1164 13.7985ZM3.3001 9.82004C1.37616 9.22281 1.37615 6.49965 3.30011 5.90239L2.79187 4.26518C-0.74014 5.36162 -0.740156 10.3608 2.79187 11.4573L3.3001 9.82004ZM3.30011 5.90239L16.1164 1.92391L15.6082 0.286694L2.79187 4.26518L3.30011 5.90239ZM16.1164 1.92391C16.2379 1.88619 16.3212 1.86679 16.3844 1.85982C16.4434 1.85332 16.4572 1.86106 16.448 1.858L16.9871 0.230704C16.4294 0.0459363 15.8964 0.197221 15.6081 0.286694L16.1164 1.92391ZM16.4479 1.85798C16.5908 1.90534 16.7876 2.03993 17.0092 2.36308C17.2291 2.68379 17.4349 3.13617 17.6096 3.70846C17.9585 4.85191 18.1429 6.34114 18.1429 7.86121C18.1429 9.38128 17.9585 10.8705 17.6096 12.014C17.4349 12.5862 17.2291 13.0386 17.0092 13.3593C16.7876 13.6825 16.5908 13.817 16.4479 13.8644L16.9872 15.4917C17.6051 15.2869 18.074 14.8378 18.4231 14.3287C18.7738 13.8171 19.0434 13.1886 19.2492 12.5143C19.6611 11.1645 19.8571 9.49741 19.8571 7.86121C19.8571 6.22501 19.6611 4.55796 19.2492 3.20813C19.0434 2.53378 18.7738 1.90527 18.4231 1.3937C18.074 0.884578 17.6051 0.435523 16.9872 0.230732L16.4479 1.85798ZM16.4478 13.8644C16.4571 13.8614 16.4434 13.8691 16.3845 13.8626C16.3213 13.8556 16.238 13.8362 16.1164 13.7985L15.6082 15.4357C15.8962 15.5251 16.4295 15.6766 16.9873 15.4916L16.4478 13.8644Z"
                                        fill="currentColor"/>
                                </svg>

                            </div>
                            <span>{{__('affiliate.My Affiliate')}}</span>
                        </a>
                    </li>
                @endif

                @if(isModuleActive('SupportTicket') && permissionCheck('student.support-ticket.index'))
                    <li>
                        <a href="{{route('student.support-ticket.index')}}"
                           class=" d-flex align-items-center {{ routeIs('student.support-ticket.index')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="18" height="18" viewBox="0 0 18 18" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M1.32007 12.086L1.02328 8.77534C0.701996 4.91262 3.7235 1 9.00889 1C14.2942 1 17.3157 4.91262 16.9944 8.77534L16.6977 12.086M11.4659 11.2744C11.5897 9.8596 12.8369 8.81305 14.2516 8.93683L14.3937 8.94925C15.8084 9.07303 16.8549 10.3203 16.7311 11.735L16.4884 14.5096C16.3647 15.9244 15.1174 16.971 13.7026 16.8472L13.5607 16.8347C12.1459 16.7109 11.0994 15.4638 11.2231 14.049L11.4659 11.2744ZM1.28658 11.7352C1.16281 10.3204 2.20935 9.07318 3.62411 8.9494L3.76611 8.93697C5.18086 8.8132 6.42809 9.85975 6.55186 11.2745L6.79461 14.0491C6.91838 15.4639 5.87184 16.7112 4.45707 16.8349L4.31508 16.8473C2.90033 16.9711 1.6531 15.9246 1.52932 14.5098L1.28658 11.7352Z"
                                        stroke="currentColor" stroke-width="1.71429"/>
                                </svg>

                            </div>
                            <span>{{__('ticket.support_ticket')}}</span>
                        </a>
                    </li>
                @endif
                @if(isModuleActive('SkillAndPathway') && permissionCheck('mySkill'))
                    <li>
                        <a href="{{route('mySkill')}}"
                           class=" d-flex align-items-center {{ routeIs('mySkill')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="21" height="17" viewBox="0 0 21 17" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M16.2888 11.8825L14.0501 1C14.8585 1 14.9149 1 16.7556 1C18.5963 1 18.932 2.40947 18.8698 3.1142M14.6409 4.27578L4.81529 11.8546M5.54698 2.86492H9.04867M7.16933 2.91762L10.3574 7.62121M16.2526 15.6787C18.3223 15.6787 20 14.001 20 11.9313C20 9.86173 18.3223 8.18397 16.2526 8.18397C14.1829 8.18397 12.5052 9.86173 12.5052 11.9313C12.5052 14.001 14.1829 15.6787 16.2526 15.6787ZM4.74742 15.6787C6.81706 15.6787 8.49484 14.001 8.49484 11.9313C8.49484 9.86173 6.81706 8.18397 4.74742 8.18397C2.67778 8.18397 1 9.86173 1 11.9313C1 14.001 2.67778 15.6787 4.74742 15.6787Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                </svg>

                            </div>
                            <span>{{__('skill.My Skill')}}</span>
                        </a>
                    </li>
                @endif

                @if(permissionCheck('myQA'))
                    <li>
                        <a href="{{route('myQA')}}"
                           class=" d-flex align-items-center {{ routeIs('myQA')  ? 'active' : '' }}">
                            <div class="menu_icon">
                                <svg width="21" height="17" viewBox="0 0 21 17" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M16.2888 11.8825L14.0501 1C14.8585 1 14.9149 1 16.7556 1C18.5963 1 18.932 2.40947 18.8698 3.1142M14.6409 4.27578L4.81529 11.8546M5.54698 2.86492H9.04867M7.16933 2.91762L10.3574 7.62121M16.2526 15.6787C18.3223 15.6787 20 14.001 20 11.9313C20 9.86173 18.3223 8.18397 16.2526 8.18397C14.1829 8.18397 12.5052 9.86173 12.5052 11.9313C12.5052 14.001 14.1829 15.6787 16.2526 15.6787ZM4.74742 15.6787C6.81706 15.6787 8.49484 14.001 8.49484 11.9313C8.49484 9.86173 6.81706 8.18397 4.74742 8.18397C2.67778 8.18397 1 9.86173 1 11.9313C1 14.001 2.67778 15.6787 4.74742 15.6787Z"
                                        stroke="currentColor" stroke-width="1.71429" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                </svg>

                            </div>
                            <span>{{__('frontend.My Questions')}}</span>
                        </a>
                    </li>
                @endif

            </ul>
        </div>
    </nav>
    <!-- sidebar part end -->
@endif
